import { ConsumerDataRequestResult } from '..';
import { BrowserType, Dict, Point, XDocument, XLineEndDecorationType, XStrokeStyle } from '../model';
export * from './shape';
export * from './shapeUtils';
export * from './vector';
export * from './conversion';
export * from './guidelines';
export declare function isDebug(): boolean;
export declare const DEBUG_FIRST_VERTEX_COLOR = "#00DC00";
export declare const DEBUG_MIDDLE_VERTEX_COLOR = "#000000";
export declare const DEBUG_LAST_VERTEX_COLOR = "#C7384F";
export declare const MAXIMUM_DISPLAY_DIMENSION = 10000;
export declare const GUIDELINE_OFFSET = 5;
export declare const GUIDELINE_COLOR = "rgb(0, 99, 0)";
/**
 * If you add a toolbar to this list, also update the WIDEST_TOOLBAR_WIDTH
 * and TALLEST_TOOLBAR_HEIGHT values below, if necessary.
 *
 * These values are used to determine the location of the floating toolbar.
 */
export declare const VERTICAL_TOOLBAR_WIDTH = 45;
export declare const SHAPES_2D_TOOLBAR_WIDTH = 334;
export declare const SHAPES_LINE_TOOLBAR_WIDTH = 442;
export declare const MULTI_SELECTION_TOOLBAR_WIDTH = 82;
export declare const ICON_TOOLBAR_WIDTH = 292;
export declare const ICON_TOOLBAR_HEIGHT = 400;
export declare const IMAGE_TOOLBAR_WIDTH = 250;
export declare const TEXT_TOOLBAR_WIDTH = 636;
export declare const TOOLBAR_HEIGHT = 44;
export declare const BORDERS_TOOLBAR_HEIGHT = 198;
export declare const BORDERS_TOOLBAR_WIDTH = 142;
export declare const COLOR_TOOLBAR_WIDTH = 142;
export declare const COLOR_TOOLBAR_HEIGHT = 124;
export declare const LINK_TOOLBAR_WIDTH = 300;
export declare const LINK_TOOLBAR_HEIGHT = 240;
export declare const EDIT_ARRANGE_MENU_HEIGHT = 265;
export declare const EDIT_ARRANGE_MENU_WIDTH = 160;
export declare const LINE_DECORATORS_TOOLBAR_HEIGHT = 44;
export declare const LINE_DECORATORS_TOOLBAR_WIDTH = 166;
export declare const TOOLBAR_SHAPE_OFFSET = 20;
export declare const ARROW_HEIGHT = 8;
export declare const GROUP_UNGROUP_BUTTONS_WIDTH = 42;
export declare const TALLEST_TOOLBAR_HEIGHT: number;
export declare const WIDEST_TOOLBAR_WIDTH = 636;
export declare const HIGHLIGHT_STROKE_COLOR = "#FFB500";
export declare const BORDER_STROKE_COLOR = "#0073C260";
export declare const ANCHOR_STROKE_COLOR = "#668592";
export declare const BORDER_STROKE_WIDTH = 1;
export declare const DEFAULT_SHAPE_WIDTH_1 = 80;
export declare const DEFAULT_SHAPE_WIDTH_2 = 160;
export declare const DEFAULT_SHAPE_HEIGHT_1 = 80;
export declare const DEFAULT_SHAPE_HEIGHT_2 = 160;
export declare const DEFAULT_ICON_SIZE = 80;
export declare const LINK_PORTAL_ELEMENT_ID = "vp-link-editor-portal-entrance";
export declare function getColors(): string[];
export declare function getLineTypes(): XStrokeStyle[];
export declare function getLineDecoratorTypes(): XLineEndDecorationType[];
export declare const isValidWebLink: (url: string) => boolean;
export declare const isPlaceholderLink: (url: string) => RegExpMatchArray | null;
export declare const isValidEmailLink: (url: string) => false | RegExpMatchArray | null;
export declare const isValidRelativeUrlLink: (url: string) => boolean;
export declare const validateUrl: (url: string) => Promise<ConsumerDataRequestResult>;
export declare const linkTypeNames: Dict<string>;
export declare function convertToCssSelector(str: string): string;
export declare function initializeActions(): {
    a: never[];
};
export declare function countOccurrences(actionArray: string[], actionId: string): number;
export declare function removeNoLongerValidActions(document: XDocument): void;
export declare const getNewShapeDimensions: (type: "ICON" | "IMAGE" | "ELLIPSE" | "RECTANGLE" | "LINE" | "CIRCLE" | "BEZIER" | "NONE") => {
    width: number;
    height: number;
};
export declare const getRectangleRelativeCoordinates: ({ x, y, width, height, }: {
    x: number;
    y: number;
    width: number;
    height: number;
}) => {
    topLeft: Point;
    topRight: Point;
    bottomLeft: Point;
    bottomRight: Point;
};
export declare const getBrowserType: () => "" | BrowserType;
//# sourceMappingURL=index.d.ts.map