export declare type Dict<T> = {
    [k: string]: T;
};
export declare type FontSize = 'S' | 'M' | 'L' | 'XL' | 'XXL';
export declare type FontStyle = 'bold' | 'italic' | 'underline' | 'normal';
export declare type HorizontalAlignment = 'left' | 'center' | 'right';
export declare type VerticalAlignment = 'top' | 'middle' | 'bottom';
export declare type LineTerminus = 'start' | 'end';
export declare type ClipboardDataType = 'json' | 'other';
export interface XPosition {
    xleft: number;
    xtop: number;
}
/** Dimensions of a shape on the canvas */
export interface XDimension {
    xwidth: number;
    xheight: number;
}
/** Types of Action that a shape can have*/
export declare enum XActionType {
    NONE = "none",
    SHOW = "sho",
    HIDE = "hid",
    SHOW_HIDE = "shohid"
}
export interface XAction {
    id: string;
    type: XActionType;
    properties?: XActionProperty;
}
export interface ActionState {
    visible: boolean;
}
export interface XActionTriggers {
    actionId: string;
    triggerIndexes: string;
}
export interface XActionTargets {
    actionId: string;
    targetIndexes: string;
}
export interface XActionProperty {
    xtype: string;
    targ: string[];
    trig: string[];
}
export interface Point {
    x: number;
    y: number;
}
/** A reference position on the canvas */
export interface XAnchor extends Point {
    type: null;
}
export interface XType {
    xtype: string;
}
export declare type XLineEndDecorationType = 'none' | 'noarrow' | 'arr1' | 'disc1' | 'diamond1';
/** The style of the line ends. It can be used to transform a simple line to an arrow. */
export interface XLineEndDecoration {
    /**  Describes the style of the line end decoration */
    xtype: XLineEndDecorationType;
    xfilled?: boolean;
}
/** The line style, it can be dashed, more frequently dashed, solid or hidden. */
export declare type XStrokeStyle = 'none' | 'dottedstroke' | 'dashedstroke' | 'nostroke' | 'solidstroke';
export interface XStroke {
    /** Describes the start of the line */
    xstart: XLineEndDecoration;
    /** Describes the end of the line */
    xend: XLineEndDecoration;
    /** Scale 0 to 100, 0 is transparent, 100 is filled */
    xalpha: number;
    /** Strange numeric color representation, see utils to convert to hex */
    xcolor: number | string;
    /** Line width */
    xthickness: number;
    /** Line style */
    xtype: XStrokeStyle;
}
export interface XFill {
    /** Not sure, known values include: 'linear' */
    xgtype?: string;
    /** Opacity, the value scales from 0 to 100, 0 is transparent, 100 is filled. */
    xalpha?: number;
    /** Strange numeric color representation, see utils on how to convert to hex */
    xcolor: number | string;
    /** Not sure, probably can be either normal fill or some sort of gradient known values include: 'solidfill' */
    xtype?: string;
}
export declare enum XLinkType {
    NONE = "none",
    URL = "url",
    ERP = "erpfunc",
    REPORT = "report",
    BO_REPORT = "reportbo",
    QUERY = "request",
    STATISTICS = "stat",
    INQUIRY = "consult",
    HELP = "x3help",
    PROCESS = "page"
}
export declare enum XLinkTargetType {
    SELF = "_self",
    BLANK = "_blank"
}
export interface XLinkProps {
    /** Type of the link */
    xtype?: XLinkType;
    /** Only applicable to URL type links */
    xtarget?: XLinkTargetType;
    /** Target entity code, in case of URL the URL */
    xcode?: string;
    /** Human friendly label for the code field */
    xlabel?: string;
    /** Transaction code */
    xparam1?: string;
    /** Human friendly label for the transaction ID field */
    xparam1label?: string;
    /** Record ID field */
    xparam2?: string;
    /** Help type */
    xhelptype?: 'xhfunc';
}
/**
 * Text format description. This object determines the styling and formatting attributes of a shape's label. The
 * position seems to be in another object
 * */
export interface XTextFormat {
    letterSpacing?: number;
    kerning?: number;
    display?: string;
    bullet?: boolean;
    tabStops?: any[];
    blockIndent?: number;
    leading?: number;
    indent?: number;
    rightMargin?: number;
    leftMargin?: number;
    align?: HorizontalAlignment;
    underline?: boolean;
    italic?: boolean;
    bold?: boolean;
    target?: string;
    url?: string;
    color?: string;
    size?: number;
    font?: string;
    valign?: VerticalAlignment;
    fontWeight?: number;
    lineHeight?: number;
    fontStyle?: FontStyle;
}
/** Determines which shape should be rendered. This list is not complete, other shapes to be added */
export declare type XDrawBehaviorCode = 'K_API_RECT' | 'K_BZ_LINE' | 'K_API_LINE' | 'K_API_ELLIPSE' | 'K_BZ_RECT' | 'K_BZ_ELLIPSE' | 'K_BZ_POLY' | 'clipshape' | 'imageshape';
export declare type ShapeType = 'ELLIPSE' | 'RECTANGLE' | 'LINE' | 'CIRCLE' | 'BEZIER';
/**
 * Canvas Layer. It looks like the data format (and the legacy editor) allows the user to have two separated layers:
 * background and foreground. The user can edit and hide them individually.
 * */
export interface XLayer {
    /** Layer ID */
    id: number;
    /** Shapes of the layer */
    xpropsArr: XShape[];
    /** Opacity, the value scales from 0 to 100, 0 is transparent, 100 is filled. */
    alpha: number;
    visible: boolean;
    /** Not sure */
    lock: boolean;
}
/** A shape element on the canvas */
export interface XShape {
    /** ID, looks like it is datastemp based. It can be used as a react key. */
    uniqueID: string;
    /** The shape type. This property determines what kind of shape is drawn, e.g a rectangle or an ellipse */
    xdrawBehaviorCode: XDrawBehaviorCode | null;
    /**
     * Corner anchor points of an object. In case of an ellipse, it's not the bounding box, but 9, 12, 3 and 6 hours
     * of the shape.
     * */
    xanchors: XAnchor[];
    /** The style of the shape's lines */
    xstrokeProps?: XStroke;
    /** The style of the shape's shadow */
    xshadowProps?: XType;
    /** XML With the text */
    xtext?: string;
    /** Position of the text */
    xcaptionPos?: XPosition;
    xcaptionSize?: XDimension;
    xtextFormat?: XTextFormat;
    xlinkProps?: XLinkProps;
    xshapeType?: string;
    xrotationAngle?: number;
    /** Action related properties */
    xactionProps?: XActionProperty;
    group?: number[];
}
export declare type FillableShape = XRectangleShape | XImageShape | XEllipseShape;
interface Fillable {
    /** The style of the shape's body */
    xfillProps?: XFill;
}
/** A line shape. It has special "start" and "end" attributes which can transform it into an arrow for instance. */
export declare type XLineShape = XShape;
/** A simple rectangle shape. */
export interface XRectangleShape extends XShape, Fillable {
}
/** A simple rectangle shape. */
export interface XImageShape extends XShape, Fillable {
    /** Image Collection ID */
    bibid: string;
    /** Image resource file name within the collection */
    eltid: string;
    /** Image size */
    xsize: XDimension;
    /** The image's contents if it is a custom image*/
    imageSrc?: string;
    /** Very old shapes (e.g. from X3 v5) had different property names for eltid and bibid */
    xclipName?: string;
    xbibName?: string;
}
/** A simple ellipse shape. */
export interface XEllipseShape extends XShape, Fillable {
}
/** A simple polygon shape. */
export interface XPolygonShape extends XShape, Fillable {
}
/**
 * A visual process document. This top level entity
 */
export interface XDocument {
    /** Actions, details to be investigated. */
    acts: Actions;
    /** The layers of the canvas, legacy documents have two: a foreground and a background one. */
    layersArr: XLayer[];
    /** To be determined. */
    reachedGroupNum: number;
    /** Size of the document in pixels */
    contentSize: XDimension;
    /** To be determined. */
    docDims: XDimension & XPosition;
    /** The ID of the active layer */
    currentLayerId: number;
}
/** Actions collection */
export interface Actions {
    a: XAction[];
}
export declare enum BrowserType {
    CHROME = "Chrome",
    EDGE = "Edg",
    FIREFOX = "Firefox",
    SAFARI = "Safari"
}
export {};
//# sourceMappingURL=model.d.ts.map