import Konva from 'konva';
import { KonvaEventObject } from 'konva/types/Node';
import * as React from 'react';
import { ActionState, Dict, XActionProperty, XDocument, XLinkProps, XShape } from '../model';
import { UpdateShapeInfo } from '../utils';
import { TextObject } from '../utils/xmlParser';
export interface VpShapeRouterProps {
    rotation: number;
    canEdit: boolean;
    isShapeSelected: (id: string) => boolean;
    isShapeHighlighted: (groupRef: React.RefObject<any>) => boolean;
    isInTextEditingMode: boolean;
    setTextEditingMode: (enabled: boolean) => void;
    /** Link content information displayed overlapping the shape */
    isLinkInfoDisplayed: boolean;
    /** Action shape numbers displayed overlapping the shapes */
    areActionNumbersDisplayed: boolean;
    document?: XDocument;
    /** Maintain various shape action states  */
    actionStates?: Dict<ActionState>;
    /** Trigger and targets of the rule currently selected in the action editor */
    selectedAction: XActionProperty;
    layerId: string;
    transformerRef?: React.RefObject<any>;
    onShapeClick: (evt: KonvaEventObject<MouseEvent>) => void;
    onShapeDoubleClick: (evt: KonvaEventObject<MouseEvent>, groupRef: React.RefObject<any>) => void;
    onLinkClick: (xlink: XLinkProps) => void;
    onMouseLeaveShape: () => void;
    onMouseOverShape: () => (shape?: XShape) => void;
    /** Event that is triggered en user right clicks on a shape  */
    onShapeRightClick: (evt: Konva.KonvaEventObject<PointerEvent>) => void;
    saveShape: (changes: UpdateShapeInfo) => void;
    saveShapeAndHistory: (changes: UpdateShapeInfo) => void;
    /** Resolves the images to URLs from for Image shapes */
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
    onTransformLegacyShapes: (shape: XShape, textObjects: TextObject[]) => void;
    xshape: XShape;
    transformLink: (textObject: TextObject) => void;
}
interface VpShapeRouterState {
    textObjects: TextObject[] | null;
}
export declare class VpShapeRouter extends React.Component<VpShapeRouterProps, VpShapeRouterState> {
    constructor(props: VpShapeRouterProps);
    setText(): void;
    componentDidMount(): void;
    componentDidUpdate(prevProps: Readonly<VpShapeRouterProps>): void;
    onClick: (evt: KonvaEventObject<MouseEvent>) => void;
    onDoubleClick: (evt: KonvaEventObject<MouseEvent>, groupRef: React.RefObject<any>) => void;
    /**
     * The text must be surrounded with the <TEXTAREA> tags due to a legacy limitation. The X3 supervisor has
     * a special behavior to extract the text from translation: it looks for these tags in the text content so
     * in order not to break that process we need to maintain these tags.
     *  */
    onEditedText: (value: string) => void;
    isShapeVisible: (shape: XShape) => boolean;
    isShapeValid: (shape: XShape) => boolean;
    render(): JSX.Element | null;
}
export {};
//# sourceMappingURL=vp-shape-router.d.ts.map