import * as React from 'react';
import { Point, XLineShape } from '../model';
import { VpShapeProps } from './common-props';
export declare class VpLine extends React.Component<VpShapeProps<XLineShape>> {
    private groupRef;
    componentDidMount(): void;
    componentDidUpdate(): void;
    attachGroupToTransformer: () => void;
    detachGroupFromTransformer: () => void;
    updateTransformer: () => void;
    dragEnd: () => void;
    transformEnd: () => void;
    getUpdatedShape: () => {
        shape: {
            xanchors: {
                type: null;
                x: number;
                y: number;
            }[];
            xcaptionPos: import("../model").XPosition | undefined;
            xcaptionSize: import("../model").XDimension | undefined;
            xtext: string | undefined;
        };
        layerId: string;
        shapeId: string;
    };
    getPoints(): {
        start: Point;
        end: Point;
    };
    getArrowRotation({ start, end }: {
        start: Point;
        end: Point;
    }): number;
    getLineOffset: (from: import("../model").LineTerminus) => number;
    renderVertices: ({ start, end }: {
        start: Point;
        end: Point;
    }) => JSX.Element;
    getHighlightProps: (start: Point) => {
        highlightProps: {
            strokeScaleEnabled: boolean;
            strokeEnabled: boolean;
            stroke: string;
            strokeWidth: number;
            listening: boolean;
        } | undefined;
        highlightBox: {
            x: number;
            y: number;
            width: number;
            height: number;
        } | undefined;
    };
    render(): JSX.Element;
}
//# sourceMappingURL=vp-line.d.ts.map