import * as React from 'react';
import { XImageShape } from '../model';
import { VpShapeProps } from './common-props';
export interface VpImageProps extends VpShapeProps<XImageShape> {
    /** Resolves the images to URLs from for Image shapes */
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
}
export interface VpImageState {
    image?: HTMLImageElement;
    canvas?: HTMLCanvasElement;
}
export declare class VpImage extends React.Component<VpImageProps, VpImageState> {
    constructor(props: VpImageProps);
    componentDidUpdate(oldProps: VpImageProps): void;
    componentDidMount(): void;
    private readonly getImageUri;
    private readonly onImageLoad;
    private readonly fetchSVG;
    private readonly imageOnLoadCallback;
    private readonly loadImage;
    private readonly redrawSVG;
    render(): JSX.Element | null;
}
//# sourceMappingURL=vp-image.d.ts.map