import * as React from 'react';
import { ShapeBeingCreated } from '../../index';
import { Dict, XAction, XActionTargets, XActionTriggers, XDocument } from '../../model';
import './vp-vertical-toolbar-styles.css';
interface VpVerticalToolbarProps {
    icons: Dict<string[]>;
    onAddIcon: (collectionId: string, resourceId: string) => (event: React.MouseEvent<HTMLImageElement, MouseEvent>) => void;
    onSaveActions: (actions: XAction[], triggers: XActionTriggers[], targets: XActionTargets[]) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onCancelActionEditor: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onEditActionFieldClick: (triggerValue: string, targetValue: string) => (event: React.MouseEvent<HTMLInputElement, MouseEvent>) => void;
    onToggleActionNumbers: () => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onMoveActionEditor: (vertical: boolean) => (event: React.MouseEvent<HTMLButtonElement, MouseEvent>) => void;
    onEditActionFieldChange: (triggerValue: string, targetValue: string) => void;
    changeSelectedIcon: (icon: VpVerticalToolbarButton) => void;
    onAddIconButtonClick: () => void;
    onEditActionsButtonClick: () => void;
    areActionNumbersDisplayed: boolean;
    onExportDocumentButtonClick: () => void;
    onUndoButtonClick: () => void;
    onRedoButtonClick: () => void;
    onCreateShape: (shapeType: ShapeBeingCreated) => void;
    onCreateShapeButtonClick: () => void;
    onImportDocumentButtonClick: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onAddImageButtonClick: (event: React.ChangeEvent<HTMLInputElement>) => void;
    onSelectAllButtonClick: () => void;
    selectedButton: VpVerticalToolbarButton;
    resolveImageUrl: (collectionId: string, resourceId: string) => string;
    resolveUndoStatus: () => boolean;
    resolveRedoStatus: () => boolean;
    imageInputRef?: React.RefObject<HTMLInputElement>;
    document: XDocument | undefined;
}
declare type VpVerticalToolbarButton = 'IMPORT_DOCUMENT' | 'EXPORT_DOCUMENT' | 'UNDO' | 'REDO' | 'ACTIONS' | 'ADD_IMAGE' | 'ADD_ICON' | 'CREATE_SHAPE' | 'SELECT_ALL' | 'NONE';
export declare class VpVerticalToolbar extends React.PureComponent<VpVerticalToolbarProps> {
    protected imageInputRef: React.RefObject<HTMLInputElement>;
    protected documentInputRef: React.RefObject<HTMLInputElement>;
    constructor(props: VpVerticalToolbarProps);
    getNavLinkClasses: (button: VpVerticalToolbarButton) => string;
    getUndoClass: (undoStatus: boolean) => string;
    getRedoClass: (redoStatus: boolean) => string;
    onOpenImageFileSelection: () => void;
    onOpenDocumentFileSelection: () => void;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=vp-vertical-toolbar.d.ts.map