import * as React from 'react';
import { GetDataFunction } from '../..';
import { FontSize, FontStyle, HorizontalAlignment, LineTerminus, VerticalAlignment, XLineEndDecorationType, XLinkProps, XLinkType, XShape, XStrokeStyle } from '../../model';
import { ShapeChanges } from '../../utils';
import { VpEditArrangeMenuItemType } from '../menu/vp-edit-arrange-menu';
import { TooltipMappedType } from '../vertical-toolbar/vp-vertical-toolbar-tooltips';
import './vp-toolbar-styles.css';
interface VpToolbarProps {
    onActiveToolbarGroupChange: (group: ToolbarGroup) => void;
    onBorderColor: (color: string) => void;
    onBorderType: (lineType: string) => void;
    onBorderWidth: (lineWidth: number) => void;
    onClose: () => void;
    onToolbarLinkDialogSelected: () => void;
    onDuplicate: () => void;
    onEditArrangeMenuItemClick: (clickedItemType: VpEditArrangeMenuItemType, pasteCoordinates?: ShapeChanges) => void;
    onFillColorChange: (color: string) => void;
    onFontColorChange: (color: string) => void;
    onFontHorizontalAlignmentChange: (align: HorizontalAlignment) => void;
    onFontSizeChange: (size: FontSize) => void;
    onFontStyleChange: (style: FontStyle) => void;
    onFontVerticalAlignmentChange: (valign: VerticalAlignment) => void;
    onLinkChange: (xlinkProps?: XLinkProps) => void;
    onLineDecoratorChange: (terminus: LineTerminus, decorator: XLineEndDecorationType) => void;
    onLinkMouseEvent: (linksDisplayed: boolean) => () => void;
    setSubToolbarState: (subToolbarDialogDisplayed: boolean) => void;
    onRotate: () => void;
    onGroupShapes: () => void;
    onUngroupShapes: () => void;
    getData: GetDataFunction;
    supportedLinkTypes?: XLinkType[];
    lineWidth?: number;
    strokeType?: XStrokeStyle;
    fill?: string;
    fontFill?: string;
    borderColor?: string | number;
    x: number;
    y: number;
    isToolbarTop: boolean;
    stageX: number;
    stageY: number;
    rightStageBoundX: number;
    lowerStageBoundY: number;
    shape: XShape;
    selectedShapes: XShape[];
    activeGroup: ToolbarGroup;
    showGroupButton: boolean;
    showUngroupButton: boolean;
    tooltipLabels: TooltipMappedType;
}
export declare type ButtonType = 'COLOR' | 'BORDER' | 'NONE' | 'ROTATE' | 'DUPLICATE' | 'CLOSE' | 'CLOSE_TYPOGRAPHY' | 'OPEN_TYPOGRAPHY' | 'FONTSIZE_TO_S' | 'FONTSIZE_TO_M' | 'FONTSIZE_TO_L' | 'FONTSIZE_TO_XL' | 'FONTSIZE_TO_XXL' | 'FONTSTYLE_BOLD' | 'FONTSTYLE_ITALIC' | 'FONTSTYLE_UNDERLINE' | 'FONTALIGN_TO_LEFT' | 'FONTALIGN_TO_CENTER' | 'FONTALIGN_TO_RIGHT' | 'FONTVALIGN_TO_TOP' | 'FONTVALIGN_TO_MIDDLE' | 'FONTVALIGN_TO_BOTTOM' | 'FONTCOLOR' | 'GROUP' | 'LINE_TO_SOLID' | 'LINE_TO_DOTTED' | 'LINE_TO_DASHED' | 'LINE_START' | 'LINE_END' | 'LINK' | 'MORE' | 'UNGROUP';
declare type ButtonData = {
    leftOffset: number;
    width: number;
};
export declare enum ToolbarGroup {
    DEFAULT = "DEFAULT",
    TYPOGRAPHY = "TYPOGRAPHY",
    MULTI_SELECTION = "MULTI_SELECTION",
    GROUP = "GROUP",
    UNGROUP = "UNGROUP",
    GROUP_UNGROUP = "GROUPING"
}
declare type ActiveTextToolbarButtons = {
    fontSize: FontSize;
    fontStyle: FontStyle;
    horizontalAlignment: HorizontalAlignment;
    verticalAlignment: VerticalAlignment;
};
declare type ActiveLineDecoratorToolbarButtons = {
    start: XLineEndDecorationType;
    end: XLineEndDecorationType;
};
interface VpToolbarState {
    displayEditArrangeMenu: boolean;
    displayToolbarColors: boolean;
    displayToolbarBorders: boolean;
    displayToolbarFontColors: boolean;
    displayToolbarLinks: boolean;
    displayToolbarLineStart: boolean;
    displayToolbarLineEnd: boolean;
    activeToolbarButton: ButtonType;
    activeToolbarGroup: ToolbarGroup;
    activeTextToolbarButtons: ActiveTextToolbarButtons;
    activeLineStyleToolbarButtons: XStrokeStyle;
    activeLineDecoratorToolbarButtons: ActiveLineDecoratorToolbarButtons;
    buttonLeftOffset: number;
    buttonWidth: number;
}
export interface VpToolbarMenuItem {
    type: ButtonType;
    text: string;
    classes?: () => string;
    element?: () => JSX.Element;
    isAvailable: () => boolean;
}
export interface VPStage {
    x: number;
    y: number;
    lowerBoundary: number;
    rightBoundary: number;
}
export interface VPParentToolbar {
    x: number;
    y: number;
    height: number;
    isAboveObject: boolean;
    clickedButton: {
        leftOffset: number;
        width: number;
    };
}
export interface VPPopup {
    height: number;
    width: number;
    arrowHeight: number;
}
export declare class VpToolbar extends React.Component<VpToolbarProps, VpToolbarState> {
    isGroupOrSingle: () => boolean;
    getTypeAndTextToolbarItem: (type: ButtonType) => {
        type: ButtonType;
        text: string;
    };
    private readonly toolbarMenuItems;
    constructor(props: VpToolbarProps);
    componentDidUpdate(prevProps: any, _prevState: any): void;
    setDisplayToolbarColors: (parentButton: ButtonData) => void;
    setDisplayToolbarBorders: (parentButton: ButtonData) => void;
    setDisplayToolbarFontColors: (parentButton: ButtonData) => void;
    setDisplayToolbarLinks: (parentButton: ButtonData) => void;
    setDisplayToolbarLineStartDecorators: (parentButton: ButtonData) => void;
    setDisplayToolbarLineEndDecorators: (parentButton: ButtonData) => void;
    setDisplayEditArrangeMenu: (parentButton: ButtonData) => void;
    onCloseLinkTooltip: () => void;
    getFillActionClasses(): string;
    getBorderActionClasses(): string;
    getNavLinkClassNames(selected: ButtonType): string;
    getFontSizeClasses(button: FontSize): string;
    getFontStyleClasses(button: FontStyle): string;
    getVerticalAlignmentClasses(button: VerticalAlignment): string;
    getHorizontalAlignmentClasses(button: HorizontalAlignment): string;
    getLineStyleClasses(button: XStrokeStyle): string;
    getLineEndStyleElement(button: XStrokeStyle): JSX.Element;
    onFontSizeChange: (fontSize: FontSize) => void;
    onFontStyleChange: (fontStyle: FontStyle) => void;
    onHorizontalAlignmentChange: (horizontalAlignment: HorizontalAlignment) => void;
    onVerticalAlignmentChange: (verticalAlignment: VerticalAlignment) => void;
    onLineDecoratorChange: (terminus: LineTerminus, decorator: XLineEndDecorationType) => void;
    onLineStyleChange: (lineStyle: XStrokeStyle) => void;
    onLinkChange: (xlink?: XLinkProps | undefined) => void;
    getButtonData: (buttonElement: EventTarget & HTMLLIElement) => ButtonData;
    onClick: (clicked: ButtonType) => (_: React.MouseEvent<HTMLLIElement, MouseEvent>) => void;
    render(): JSX.Element;
}
export {};
//# sourceMappingURL=vp-toolbar.d.ts.map