import * as React from 'react';
import { ConsumerDataRequestResult, GetDataFunction } from '../..';
import { XLinkProps, XLinkType, XShape } from '../../model';
import { VPParentToolbar, VPStage } from '../toolbar/vp-toolbar';
export interface VpLinkEditorProps {
    onLinkChange: (xlink?: XLinkProps) => void;
    onCloseLinkTooltip: () => void;
    getData: GetDataFunction;
    shape: XShape;
    stage: VPStage;
    parentToolbar: VPParentToolbar;
    supportedLinkTypes?: XLinkType[];
}
export interface LinkTypeRuleSet {
    firstFieldLabel: string;
    firstFieldLookupFunction?: () => Promise<ConsumerDataRequestResult>;
    secondFieldLabel?: string;
    secondFieldLookupFunction?: () => Promise<ConsumerDataRequestResult>;
    validate: () => Promise<ConsumerDataRequestResult>;
}
export interface VpLinkEditorState extends XLinkProps {
    errorMessage?: string;
    loading?: boolean;
}
export declare class VpLinkEditor extends React.PureComponent<VpLinkEditorProps, VpLinkEditorState> {
    private readonly linkTypeRules;
    constructor(props: VpLinkEditorProps);
    onRemoveLink: () => void;
    onRemoveError: () => void;
    onSaveLink: () => void;
    onFieldChange: (field: "xtype" | "xtarget" | "xcode" | "xlabel" | "xparam1" | "xparam1label" | "xparam2" | "xhelptype") => (event: React.ChangeEvent<HTMLInputElement | HTMLSelectElement | HTMLTextAreaElement>) => void;
    onFirstFieldLookupClick: () => void;
    onSecondFieldLookupClick: () => void;
    renderFirstField: () => JSX.Element | null;
    renderSecondField: () => JSX.Element | null;
    renderThirdField: () => JSX.Element | null;
    renderErrorDialog: () => React.ReactPortal;
    renderRemoveLink: () => JSX.Element | null;
    render(): JSX.Element;
}
//# sourceMappingURL=vp-link-editor.d.ts.map