"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TestCopWithDependsOnNode = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const _1 = require(".");
function callExpression(value) {
    return 2 * value;
}
let TestCopWithDependsOnNode = class TestCopWithDependsOnNode extends xtrem_core_1.Node {
    constructor() {
        super(...arguments);
        this._internalValue = 2;
    }
};
exports.TestCopWithDependsOnNode = TestCopWithDependsOnNode;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 50 }),
        isPublished: true,
        isStored: true,
        defaultValue() {
            return 'default value';
        },
    })
], TestCopWithDependsOnNode.prototype, "value", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 50 }),
        isPublished: true,
        isStored: true,
    })
], TestCopWithDependsOnNode.prototype, "details", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 50 }),
        isPublished: true,
        isStored: true,
        dependsOn: ['value'],
        defaultValue() {
            return this.value;
        },
    })
], TestCopWithDependsOnNode.prototype, "propWithValidDependsOn", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
    })
], TestCopWithDependsOnNode.prototype, "testingValue", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isVital: true,
        node: () => _1.TestVitalReferenceChild,
        reverseReference: 'parent',
    })
], TestCopWithDependsOnNode.prototype, "vitalChild", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 50 }),
        isPublished: true,
        isStored: true,
        dependsOn: [{ vitalChild: ['name'] }],
        async updatedValue() {
            return (await this.vitalChild).name;
        },
    })
], TestCopWithDependsOnNode.prototype, "vitalChildName", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        defaultValue() {
            return this._id;
        },
    })
], TestCopWithDependsOnNode.prototype, "dependencyOnId", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['testingValue'],
        async updatedValue() {
            return (await this.testingValue) < 10 ? this.dependencyOnSelf : this.testingValue;
        },
    })
], TestCopWithDependsOnNode.prototype, "dependencyOnSelf", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
    })
], TestCopWithDependsOnNode.prototype, "integerValueA", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
    })
], TestCopWithDependsOnNode.prototype, "integerValueB", void 0);
__decorate([
    xtrem_core_1.decorators.integerArrayProperty({
        isStored: true,
        isNullable: true,
        isPublished: true,
    })
], TestCopWithDependsOnNode.prototype, "integerArrayVal", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA', 'integerValueB'],
        async updatedValue() {
            return (await this.integerValueA) * (await this.integerValueB);
        },
    })
], TestCopWithDependsOnNode.prototype, "simpleExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA', 'integerValueB'],
        async updatedValue() {
            switch (await this.integerValueA) {
                case 1: {
                    return this.integerValueA;
                }
                case 2: {
                    return this.integerValueB;
                }
                default:
                    return 0;
            }
        },
    })
], TestCopWithDependsOnNode.prototype, "switchStatement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA', 'integerValueB'],
        async updatedValue() {
            if ((await this.integerValueA) === 1) {
                return this.integerValueA;
            }
            if ((await this.integerValueB) === 0)
                throw new Error('not supported operation');
            return this.integerValueB;
        },
    })
], TestCopWithDependsOnNode.prototype, "ifStatement", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA'],
        async updatedValue() {
            const value = this._internalValue * (await this.integerValueA);
            return value;
        },
    })
], TestCopWithDependsOnNode.prototype, "variableDeclaration", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA'],
        async updatedValue() {
            return callExpression(await this.integerValueA);
        },
    })
], TestCopWithDependsOnNode.prototype, "callExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerArrayVal'],
        async updatedValue() {
            return (await this.integerArrayVal).sort((v1, v2) => v1 - v2)[0];
        },
    })
], TestCopWithDependsOnNode.prototype, "arrowFunctionExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerArrayVal'],
        async updatedValue() {
            return [...[1, 2, 3], ...new Set(await this.integerArrayVal)][0];
        },
    })
], TestCopWithDependsOnNode.prototype, "arrayExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerValueA', 'integerValueB'],
        async updatedValue() {
            return (await this.integerValueA, await this.integerValueB)
                ? (await this.integerValueA) / (await this.integerValueB)
                : 0;
        },
    })
], TestCopWithDependsOnNode.prototype, "sequenceExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
    })
], TestCopWithDependsOnNode.prototype, "length", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['integerArrayVal'],
        async updatedValue() {
            return (await this.integerArrayVal)?.sort((v1, v2) => v1 - v2)[0];
        },
    })
], TestCopWithDependsOnNode.prototype, "chainExpression", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        dependsOn: ['length'],
        async updatedValue() {
            return (await this.integerArrayVal).length ? (await this.integerArrayVal).length : this.length;
        },
    })
], TestCopWithDependsOnNode.prototype, "lengthMember", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        dataType: () => new xtrem_core_1.StringDataType({ maxLength: 50 }),
        dependsOn: ['integerValueA', 'integerValueB'],
        async updatedValue() {
            return `${await this.integerValueA}+${await this.integerValueB}`;
        },
    })
], TestCopWithDependsOnNode.prototype, "templateLiteral", void 0);
exports.TestCopWithDependsOnNode = TestCopWithDependsOnNode = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'sql',
        isPublished: true,
        canCreate: true,
        canUpdate: true,
        canDelete: true,
        canDeleteMany: true,
        indexes: [],
    })
], TestCopWithDependsOnNode);
//# sourceMappingURL=test-cop-with-depends-on.js.map