// From file: @sage/xtrem-cop/build/index.d.ts
declare module '@sage/xtrem-cop/index' {
	export * from '@sage/xtrem-cop/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cop/build/lib/verify-depends-on.d.ts
declare module '@sage/xtrem-cop/lib/verify-depends-on' {
	import { Application, NodeFactory, Property } from '@sage/xtrem-core';
	export function verifyDependsOn(application: Application): void;
	export function fixDependsOn(dependsOn: any[], propertyPaths: string[]): any[];
	export function verifyPropertyDependsOn(factory: NodeFactory, property: Property): void;
	export function sanitizeCollectedDependencyPaths(arr: string[]): string[];
	export function sanitizeDependsOn(value: any, path?: string[], results?: string[]): string[];
	//# sourceMappingURL=verify-depends-on.d.ts.map
}
// From file: @sage/xtrem-cop/build/lib/index.d.ts
declare module '@sage/xtrem-cop/lib/index' {
	export * from '@sage/xtrem-cop/lib/verify-depends-on';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-cop/build/lib/explorer.d.ts
declare module '@sage/xtrem-cop/lib/explorer' {
	import * as estree from 'estree';
	export class ExplorationError extends Error {
	    readonly node: estree.BaseNode;
	    constructor(node: estree.BaseNode, message: string);
	}
	export class Explorer {
	    private static exploreThisExpression;
	    private exploreMemberExpression;
	    private exploreChainExpression;
	    private exploreConditionalExpression;
	    private exploreBinaryExpression;
	    private exploreLogicalExpression;
	    private exploreUnaryExpression;
	    private exploreTemplateLiteral;
	    private exploreBlockStatement;
	    private exploreReturnStatement;
	    private exploreSwitchStatement;
	    private exploreIfStatement;
	    private exploreCallExpression;
	    private exploreVariableDeclaration;
	    private exploreProperty;
	    private exploreObject;
	    private exploreArrayExpression;
	    private explorerNewExpression;
	    private explorerSequenceExpression;
	    private explorerThrowStatement;
	    private exploreExpressionStatement;
	    private exploreAwaitExpression;
	    exploreExpression(expression: estree.BaseExpression): string[];
	    exploreFunctionExpression(expression: estree.FunctionExpression | estree.ArrowFunctionExpression): string[];
	    exploreArrowFunctionExpression(expression: estree.ArrowFunctionExpression): string[];
	    exploreFunction(fn: () => any): string[];
	}
	//# sourceMappingURL=explorer.d.ts.map
}
declare module '@sage/xtrem-cop' {
	export * from '@sage/xtrem-cop/index';
}
