import { Config, SizeLimits } from '@sage/xtrem-shared';
import { EventEmitter } from 'events';
import { SecureContextOptions } from 'tls';
export type SslCertificateOptions = Pick<SecureContextOptions, 'ca' | 'cert' | 'key'>;
export declare class ConfigManager {
    private static config;
    private static fileWatcherMap;
    static readonly emitter: EventEmitter<[never]>;
    private static configFilePaths?;
    private static _checkDeploymentMode;
    private static _checkIgnoreVendorProtection;
    private static _checkGraphQlConfig;
    private static _checkLogLevels;
    private static _checkNewRelicConfig;
    private static _checkStorageConfig;
    private static _checkAppName;
    private static _checkAppsConfig;
    private static _checkConfig;
    private static getDefaultSqlConfig;
    /**
     * Returns a default configuration
     */
    private static getDefaultConfig;
    private static _load;
    private static _readConfigFile;
    /**
     * Read the configuration files from a given directory
     * Note: all the configuration files must be in the same folder
     */
    private static _readConfigFiles;
    /**
     * Load the configuration files from a given path
     * Note: all the configuration files must be in the same folder
     */
    private static _loadConfigFilesFromPath;
    private static _checkConfigJsonSchema;
    private static _setStorageConfig;
    private static _setServerConfig;
    private static _setAuthenticationServiceConfig;
    private static sizeLimits;
    static getSizeLimit(key: keyof SizeLimits): number;
    private static _setSslPemOptions;
    private static _notifyTlsChangeAndInstallWatcher;
    private static _tryloadPemFile;
    static load(dirname: string, source?: string, extensionPath?: string): Config;
    private static _loadConfiguration;
    static notLoadedError(): Error;
    static get current(): Config;
    static get header(): string;
    static getSetting<T>(name: string, defaultValue: T): any;
    static fixServicesConfig(): void;
}
//# sourceMappingURL=config-manager.d.ts.map