/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ConnectionPool=exports.copyFrom=exports.copyTo=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),postgres=require("pg"),copyStreams=require("pg-copy-streams"),PostgresCursor=require("pg-cursor"),Pool=require("pg-pool"),prom_client_1=require("prom-client"),profiler_1=require("./profiler");function sanitizeSqlRequest(e){return e.replace(/`/g,'"')}function query(e,t,o){const s=sanitizeSqlRequest(t);return new Promise((r,n)=>{e.query(s,o,(e,o)=>{if(e)return void n(e instanceof Error?e:new xtrem_shared_1.SystemError(`Postgres error: ${e.message}`,e));if(t.startsWith("/*RAW*/"))r(o);else if(o.rows&&o.rows.length>0&&"INSERT"===o.command)r(o.rows[0]);else if(!o.rows||0===o.rows.length&&"SELECT"!==o.command)r(o.rowCount);else r(o.rows)})})}exports.copyTo=copyStreams.to,exports.copyFrom=copyStreams.from,postgres.types.setTypeParser(postgres.types.builtins.INT8,e=>parseInt(e,10)),postgres.types.setTypeParser(postgres.types.builtins.DATE,e=>e);const defaultLogger={error:console.error,warn:console.warn,info:console.log,verbose:e=>console.log(e()),log:(e,t)=>void console.log(t())},allMetricsEnabled=(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_ALL_METRICS_ENABLED),sqlMetricsEnabled=allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_SQL_METRICS_ENABLED),poolMetrics=sqlMetricsEnabled?{stats:new prom_client_1.Gauge({name:"xtrem_sql_pool_stats",help:"The SQL pool stats",labelNames:["poolType","statName"]}),retries:new prom_client_1.Counter({name:"xtrem_sql_pool_retries",help:"Number of retries for connection allocation",labelNames:["poolType","attemptName"]}),allocationQueues:new prom_client_1.Gauge({name:"xtrem_sql_pool_allocation_queue_length",help:"Length of allocation queues per originId",labelNames:["poolType","originId"]})}:{};class ConnectionPool{#e;#t;#o;constructor(e,t){if(this.type=e,this.config=t,this.#t=Date.now(),this.#s={tryCounts:[-1,-1,-1,-1],allocationQueuesCount:0,allocationQueuesMaxCount:0},this.onNotice=e=>{switch(e.severity){case"ERROR":ConnectionPool.logger.error(`POSTGRES ERROR: ${e.message}`);break;case"WARNING":ConnectionPool.logger.warn(`POSTGRES WARNING: ${e.message}`);break;case"INFO":ConnectionPool.logger.info(`POSTGRES INFO: ${e.message}`);break;default:ConnectionPool.logger.verbose(()=>`POSTGRES ${e.severity}: ${e.message}`)}},this.#r=0,this.#n=[],this.#i=0,this._user=t.user,t.trace)this.trace=t.trace;if(this.config.connectString=`${t.hostname+(t.port?`:${t.port}`:"")}/${t.database}`,this.#e=xtrem_log_1.Logger.getLogger(__filename,"throttling"),ConnectionPool.metricsEmitter)ConnectionPool.metricsEmitter?.on("collected",()=>{this.updateMetrics()});this.#o=(0,xtrem_async_helper_1.funnel)(Number(this.config.connectionAllocationFunnelSize)||50)}get user(){return this._user}static{this.logger=defaultLogger}#s;get stats(){if(!this._pool)return;return this.#s.allocationQueuesMaxCount=Math.max(this.#s.allocationQueuesMaxCount,this.#n.length),{idleCount:this._pool.idleCount,busyCount:this._pool.totalCount-this._pool.idleCount,waitingCount:this._pool.waitingCount,totalCount:this._pool.totalCount,tryCounts:this.#s.tryCounts,allocationQueuesCount:this.#n.length,allocationQueuesMaxCount:this.#s.allocationQueuesMaxCount}}static setup(e){const{logger:t,metricsEmitter:o}=e;this.logger=t,this.metricsEmitter=o}incrementRetryCounter(e,t){const o=this.#s.tryCounts[t]??0;if(this.#s.tryCounts[t]=-1===o?1:o+1,sqlMetricsEnabled)poolMetrics.retries?.inc({poolType:e,attemptName:0===t?"failures":`retry${t}`},1)}updateMetrics(e=false){if(!sqlMetricsEnabled||!this.stats||!e&&Date.now()-this.#t<15e3)return;this.#t=Date.now();const{totalCount:t,idleCount:o,waitingCount:s,allocationQueuesCount:r,allocationQueuesMaxCount:n}=this.stats,i=t-o;if(poolMetrics.stats)poolMetrics.stats.set({poolType:this.type,statName:"total"},t),poolMetrics.stats.set({poolType:this.type,statName:"idle"},o),poolMetrics.stats.set({poolType:this.type,statName:"waiting"},s),poolMetrics.stats.set({poolType:this.type,statName:"busy"},i),poolMetrics.stats.set({poolType:this.type,statName:"queues"},r),poolMetrics.stats.set({poolType:this.type,statName:"maxQueues"},n);if(poolMetrics.allocationQueues)this.#n.forEach(e=>{poolMetrics.allocationQueues.set({poolType:this.type,originId:e.originId},e.callbacks.length)});if(poolMetrics.retries)if(-1===this.#s.tryCounts[0]){this.#s.tryCounts[0]=0;for(let e=0;e<=3;e+=1)poolMetrics.retries?.inc({poolType:this.type,attemptName:0===e?"failures":`retry${e}`},0)}}get poolSize(){return this.config.max||20}get runtimeConfig(){return{host:this.config.hostname,database:this.config.database,user:this.config.user,password:this.config.password,port:this.config.port,ssl:this.config.ssl||false,max:this.poolSize,maxUses:this.config.maxUses,idleTimeoutMillis:this.config.idleTimeoutMillis||1e4,connectionTimeoutMillis:this.config.connectionTimeoutMillis||5e3,statement_timeout:this.config.statementTimeoutMillis,query_timeout:this.config.statementTimeoutMillis?1.2*this.config.statementTimeoutMillis:void 0,options:"-c TimeZone=UTC"}}async queryDatabaseInfo(){const e=await this.pool.connect();if(!e)throw new xtrem_shared_1.LogicError("no cnx");try{const{rows:t}=await e.query("\n                SELECT\n                    version() as version,\n                    current_setting('superuser_reserved_connections')::INT as superuser_reserved_connections,\n                    current_setting('max_connections')::INT as max_connections,\n                    current_setting('shared_buffers') as shared_buffers;\n                ");if(1!==t.length)throw new xtrem_shared_1.LogicError(`bad rows length: ${t.length}`);const o=t[0],s=o.version.match(/^PostgreSQL (\d+)\.(\d+)/);if(!s)throw new xtrem_shared_1.LogicError(`cannot parse version: ${o.version}`);const[r,n]=s.slice(1).map(e=>Number.parseInt(e,10)),i={text:o.version,major:r,minor:n};let a;if(i.major>=16){const{rows:t}=await e.query("SELECT current_setting('reserved_connections')::INT as reserved_connections;");if(1!==t.length)throw new xtrem_shared_1.LogicError(`bad rows length: ${t.length}`);a=t[0].reserved_connections}else a=o.superuser_reserved_connections;const l={version:i,settings:{..._.omit(o,"version"),reserved_connections:a}};return ConnectionPool.logger.info(`Database info: ${JSON.stringify(l)}`),l}finally{e.release()}}static#a;static#l=-1;async getUsablePoolSize(){if(null==ConnectionPool.#a)ConnectionPool.#a=this.queryDatabaseInfo();const{settings:e}=await ConnectionPool.#a,{max_connections:t,reserved_connections:o,superuser_reserved_connections:s}=e,r=Math.min(this.poolSize,t-o-s);if(r<=0)throw new xtrem_shared_1.LogicError("Invalid configuration: all postgres connections are reserved or config.storage.sql.max <= 0!");return ConnectionPool.#l=r,r}get pool(){if(this._pool)return this._pool;return this._pool=new Pool(this.runtimeConfig),this._pool.on("error",e=>{ConnectionPool.logger.error(`pg-pool error: ${e.message}`)}),this._pool}async withConnection(e,t){const o=t??await this.allocConnection("<unknown>");try{return await e(o)}finally{if(!t)this.releaseConnection(o)}}static async readBlob(e){if(null==e)return null;if(e instanceof Buffer)return e;if("string"==typeof e)return Buffer.from(e,"base64");const t=Buffer.concat(await ConnectionPool.blobReader(e).readAll());if(null==t)return null;if(t instanceof Buffer)return t;if("string"==typeof t)return Buffer.from(t,"base64");return Buffer.from(t)}static async readClob(e){if(null==e)return null;const t=(await ConnectionPool.clobReader(e).readAll()).join("");return null==t?null:t}static blobReader(e){return new xtrem_async_helper_1.AsyncArrayReader(()=>[e])}static clobReader(e){return new xtrem_async_helper_1.AsyncArrayReader(()=>[e])}async _allocConnection(){const e=this.config.connectionMaxRetries||3,t=this.config.connectionRetryMillis||2e3,o=[];for(let s=1;s<=e;s+=1)try{const e=await this.#o(()=>this.pool.connect());if((this._pool?.waitingCount??0)>.15*this.poolSize)ConnectionPool.logger.warn(`Waiting for connections! totalCount: ${this._pool?.totalCount}, idleCount: ${this._pool?.idleCount}, waitingCount: ${this._pool?.waitingCount}`);return e.removeAllListeners("notice"),e.on("notice",this.onNotice),e}catch(r){this.updateMetrics(true),this.incrementRetryCounter(this.type,s),ConnectionPool.logger.error(`Retry: try number ${s}/${e} (total: ${this.#s.tryCounts[s]}): Error \r\n${r.stack}`),o.push(r.message),await new Promise(e=>{setTimeout(e,t)})}throw this.updateMetrics(true),this.incrementRetryCounter(this.type,0),ConnectionPool.logger.error(`Failed after ${e} retries (total: ${this.#s.tryCounts[0]})`),new xtrem_shared_1.SystemError(o.join("\n"))}#r;#n;#i;async allocConnection(e){const t=ConnectionPool.#l<0?await this.getUsablePoolSize():ConnectionPool.#l;if(this.#r<t)return this.#r+=1,this.#e.verbose(()=>`CONNECTION ALLOC  : allocated=${this.#r}`),this._allocConnection();let o=this.#n.find(t=>t.originId===e);if(!o)o={originId:e,callbacks:[]},this.#n.push(o);this.updateMetrics(true);const s=o;return this.#e.verbose(()=>{const t=this.#n.map(e=>e.callbacks.length);return`CONNECTION QUEUED : allocated=${this.#r}, originId=${e}, lengths=${t}`}),new Promise((e,t)=>{s.callbacks.push((o,s)=>{if(o)t(o);else if(s)e(s);else t(new xtrem_shared_1.LogicError("no connection"))})})}releaseConnection(e){if(e.release(),0===this.#n.length)return this.#e.verbose(()=>`CONNECTION RELEASE: allocated=${this.#r}`),this.#r-=1,void this.updateMetrics(true);this.#i=(this.#i+1)%this.#n.length;const t=this.#n[this.#i];this.#e.verbose(()=>`CONNECTION WAKEUP : allocated=${this.#r}, originId=${t.originId}, pending=${t.callbacks.length}`);const o=t.callbacks.shift();if(!o)throw new xtrem_shared_1.LogicError("no callback");if(0===t.callbacks.length)this.#n.splice(this.#i,1);this._allocConnection().then(e=>o(void 0,e)).catch(e=>o(e)),this.updateMetrics(true)}getProfiler(e,t,o){return(0,profiler_1.createProfiler)(()=>e,this.config.mapArgsInLogs,t,o,ConnectionPool.logger)}async execute(e,t,o,s){const r=sanitizeSqlRequest(t),n=this.getProfiler(`[${this.user}] Execute ${r}`,o,s?.logLevel);let i;try{if(this.sqlRecorder)this.sqlRecorder.recordSqlCommand(r,o);if(i=await query(e,r,ConnectionPool.convertArgs(o||[])),"number"==typeof i)i={updateCount:i};n?.success(`Result = ${JSON.stringify(i)}`)}catch(e){if(n?.fail(`Error '${e.stack}' on ${t} args=${o}`),e.detail)e.message=`${e.message}: ${e.detail}`,ConnectionPool.logger.error(e.message);if(e.internalQuery)e.message=`${e.message}\ninternalQuery: ${e.internalQuery}`;throw new xtrem_shared_1.SystemError(e.message,e)}return i}static convertArgs(e){return e.map(e=>{if(xtrem_date_time_1.DateValue.isDate(e)||xtrem_date_time_1.Datetime.isDatetime(e))return e.toJsDate();if(xtrem_date_time_1.Time.isTime(e))return e.toString();return e})}createReader(e,t,o,s){const r=this.getProfiler(`[${this.user}] Reader ${t}`,o,s?.logLevel),n=e.query(new PostgresCursor(sanitizeSqlRequest(t),o||[]));let i=true,a=0,l=[];return new xtrem_async_helper_1.AsyncGenericReader({read:async()=>{try{if(i)r?.success("query result ready"),i=false;if(0===l.length)l=await n.read(s?.pageSize||200);const e=l.shift();if(void 0!==e)a+=1;return e}catch(e){throw r?.fail(`Error '${e.stack}' on ${t} args=${o}`),e}},stop:()=>(r?.success(`POSTGRES ${a} records read`),n.close())})}async release(){if(this._pool)await this._pool.end();this._pool=void 0}}exports.ConnectionPool=ConnectionPool;
//# sourceMappingURL=pool.js.map