/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.DatabaseService=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),pool_1=require("./pool");class DatabaseService{static{this._services={}}constructor(e){this.config=e}static getInstance(e){const s=JSON.stringify(e);if(!this._services[s])this._services[s]=new DatabaseService(e);return this._services[s]}static getSysPool(e){return this.getInstance(e).sysPool}static getPool(e){return this.getInstance(e).userPool}async checkThatDatabaseExists(){if(!await this.databaseExists(this.config.database))throw new Error("Database not created yet")}get serverPool(){if(null==this._serverPool)this.validateAndFixConfig(["sysUser","sysPassword","sysDatabase"]),this._serverPool=new pool_1.ConnectionPool("server",{...this.config,user:this.config.sysUser,password:this.config.sysPassword,database:this.config.sysDatabase});return this._serverPool}get sysPool(){if(!this._sysPool)this.validateAndFixConfig(["sysUser","sysPassword"]),this._sysPool=new pool_1.ConnectionPool("sys",{...this.config,user:this.config.sysUser,password:this.config.sysPassword});return this._sysPool}get userPool(){if(null==this._userPool)this.validateAndFixConfig([]),this._userPool=new pool_1.ConnectionPool("user",this.config);return this._userPool}validateAndFixConfig(e){const s=["sysUser","sysPassword","sysDatabase"],t=["database","user"],a=["password","sysPassword"];e.forEach(e=>{if(s.includes(e)&&!this.config[e])throw new Error(`invalid config: ${e} config missing.`);if(!a.includes(e))xtrem_shared_1.validator.isAlphaNumericName(this.config[e],{throw:{name:e}})}),t.forEach(e=>{xtrem_shared_1.validator.isAlphaNumericName(this.config[e],{throw:{name:e}})}),a.forEach(e=>{if(!this.config[e])return;this.config[e]=this.config[e].replace(/'/g,"''")})}async createDatabaseIfNotExists(){const{user:e,database:s,password:t,sysUser:a,sysPassword:o,sysDatabase:i}=this.config;if(s.toLowerCase()===i?.toLowerCase())return;if(await this.databaseExists(s))return;pool_1.ConnectionPool.logger.info(`Creating database ${s}`),await this.serverPool.withConnection(async i=>{await this.createUsers(i,e,t,a,o),await this.serverPool.execute(i,`CREATE DATABASE ${s}\n                        WITH OWNER = ${e}\n                        TEMPLATE = 'template0'\n                        ENCODING = 'UTF8'\n                        CONNECTION LIMIT = -1`)})}databaseExists(e){return this.serverPool.withConnection(async s=>!!(await this.serverPool.execute(s,"select exists(SELECT datname FROM pg_catalog.pg_database WHERE datname = $1);",[e]))[0].exists)}async createUsers(e,s,t,a,o){if(a&&o)await this.createSysUser(e,a,o);if(s===a)return;if(await this.userExists(s))return;pool_1.ConnectionPool.logger.info(`Create (non-sys) user ${s}`),await this.serverPool.execute(e,`CREATE USER ${s} WITH PASSWORD '${t}'`),await this.serverPool.execute(e,`GRANT ${s} TO ${a}`)}async createSysUser(e,s,t){if(await this.userExists(s))return;pool_1.ConnectionPool.logger.info(`Create sys user ${s}`),await this.serverPool.execute(e,`CREATE USER ${s} NOSUPERUSER WITH PASSWORD '${t}'`)}userExists(e){return this.serverPool.withConnection(async s=>!!(await this.serverPool.execute(s,"SELECT exists(SELECT * from pg_roles WHERE rolname=$1)",[e]))[0].exists)}async dropUser(e,s){if(e===s)return;await this.serverPool.withConnection(async t=>{if(await this.userExists(e)){await this.serverPool.execute(t,`GRANT ${e} TO ${s}`),await this.serverPool.execute(t,`REASSIGN OWNED BY ${e} TO ${s};`),await this.serverPool.execute(t,`DROP OWNED BY ${e}`);try{await this.serverPool.execute(t,`DROP ROLE ${e}`)}catch(e){if(/role "\w+" cannot be dropped because some objects depend on it: \d+ objects in database \w+/.test(e.message))pool_1.ConnectionPool.logger.warn(e.message);else throw e}}})}async dropDatabaseIfExists(){const{user:e,database:s,sysUser:t,sysDatabase:a}=this.config;if(s.toLowerCase()===a?.toLowerCase())return;if(!await this.databaseExists(s))return;pool_1.ConnectionPool.logger.warn(`Dropping database ${s}`),await this.serverPool.withConnection(async e=>{await this.serverPool.execute(e,"SELECT pg_terminate_backend(pid)\n                FROM\n                    pg_stat_activity\n                WHERE\n                    pid <> pg_backend_pid() AND\n                    pg_stat_activity.datname = $1;",[s]),await this.serverPool.execute(e,`DROP DATABASE ${s};`)}),this._serverPool=void 0,await this.dropUser(e,t)}async renameSchema(e,s){pool_1.ConnectionPool.logger.info(`Rename schema ${e} to ${s}`);const t=new RegExp(`(${e})\\.(\\w+)`,"g"),a=["xtrem.transaction_user_id","xtrem.login_email","xtrem.user_email"];let o=0;const schemaNameFixer=(t,i,r)=>{if(a.includes(t))return t;if(i!==e)return t;return o+=1,`${s}.${r}`},i=this.sysPool;await i.withConnection(async a=>{await i.execute(a,`ALTER SCHEMA ${e} RENAME TO ${s}`);const o=(await i.execute(a,`SELECT p.proname name, pg_get_functiondef(p.oid) AS definition\n                FROM pg_proc p\n                JOIN pg_namespace n ON p.pronamespace = n.oid\n                WHERE n.nspname = '${s}'`)).filter(s=>-1!==s.definition.indexOf(`${e}.`));await(0,xtrem_async_helper_1.asyncArray)(o).forEach(async e=>{await i.execute(a,e.definition.replace(t,schemaNameFixer))});const r=await i.execute(a,`SELECT table_name, column_name, column_default\n                        FROM information_schema.columns\n                        WHERE table_schema='${s}' and column_default like '%${e}.%'\n                        ORDER BY ordinal_position;`);await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async e=>{const o=e.column_default.replace(t,schemaNameFixer);await i.execute(a,`ALTER TABLE ${s}.${e.table_name} ALTER COLUMN ${e.column_name} SET DEFAULT ${o}`)})}),pool_1.ConnectionPool.logger.info(`Applied ${o} renamings`)}}exports.DatabaseService=DatabaseService;
//# sourceMappingURL=database-service.js.map