import { ConnectionPool } from './pool';
import { Connection, PoolConfig } from './types';
export declare class DatabaseService {
    readonly config: PoolConfig;
    private _serverPool;
    private _sysPool;
    private _userPool;
    /**
     * Dictionary of services indexed by their configuration, may contain the readonly and writable services
     */
    private static _services;
    private constructor();
    static getInstance(config: PoolConfig): DatabaseService;
    static getSysPool(config: PoolConfig): ConnectionPool;
    static getPool(config: PoolConfig): ConnectionPool;
    checkThatDatabaseExists(): Promise<void>;
    /** Sys connections are privileged. Then can perform DDL operations in a database created by server connections */
    get sysPool(): ConnectionPool;
    /** User connections are non-privileged. They can only perform DML operations in tables created by sys connections */
    get userPool(): ConnectionPool;
    private validateAndFixConfig;
    /**
     * Create database
     */
    createDatabaseIfNotExists(): Promise<void>;
    databaseExists(name: string): Promise<boolean>;
    /**
     * Create (if needed) the roles for 'user' and 'sysUser'
     */
    createUsers(cnx: Connection, user: string, password: string, sysUser?: string, sysPassword?: string): Promise<void>;
    /**
     * Create (if not existing) the sysUser
     */
    private createSysUser;
    private userExists;
    dropDatabaseIfExists(): Promise<void>;
    /**
     * Rename a schema in database
     */
    renameSchema(oldName: string, newName: string): Promise<void>;
}
//# sourceMappingURL=database-service.d.ts.map