// From file: @sage/wh-stock/build/index.d.ts
declare module '@sage/wh-stock/index' {
	export * from '@sage/wh-stock/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock/build/lib/index.d.ts
declare module '@sage/wh-stock/lib/index' {
	export * as enums from '@sage/wh-stock/lib/enums/index';
	export * as nodeExtensions from '@sage/wh-stock/lib/node-extensions/index';
	export * as nodes from '@sage/wh-stock/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-stock/lib/service-options/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock/build/lib/service-options/index.d.ts
declare module '@sage/wh-stock/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/transfer-movement.d.ts
declare module '@sage/wh-stock/lib/nodes/transfer-movement' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class TransferMovement extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly transferNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly assemblingWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
	    readonly subWaveNumber: Promise<integer | null>;
	    readonly adjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly containerNumber: Promise<string>;
	    readonly originStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly originAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly sourceProduct: Reference<sageWhProductData.nodes.Product>;
	    readonly originStockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly originQuantity: Promise<decimal | null>;
	    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly numberOfContainer: Promise<decimal | null>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly numberOfConsumptionUnit: Promise<decimal | null>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly status: Promise<sageWhProductData.enums.ReplenishmentMovementType | null>;
	    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
	    readonly masterStockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly masterContainerNumber: Promise<string>;
	    readonly masterProduct: Reference<sageWhProductData.nodes.Product | null>;
	    readonly date: Promise<date | null>;
	    readonly time: Promise<string>;
	    readonly homogeneousQuantity: Promise<decimal | null>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly homogeneousContainerCoefficient: Promise<decimal | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly lotNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly reservationNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly sortPreparationOrder: Promise<string>;
	    readonly rowLevel: Promise<string>;
	    readonly travelSequence: Promise<string>;
	    readonly transferObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly transferStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly transferAddress: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly position: Promise<integer | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly validatingUser: Promise<string>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly flowNumber: Promise<integer | null>;
	    readonly pickingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly pickingUser: Promise<string>;
	    readonly pickingDate: Promise<date | null>;
	    readonly pickingTime: Promise<integer | null>;
	    readonly groupingCode: Promise<string>;
	    readonly depositObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly depositStore: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly depositLocation: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly containerLevels: Collection<sageWhStock.nodes.TransferMovementContainerLevels>;
	}
	//# sourceMappingURL=transfer-movement.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/transfer-movement-container-levels.d.ts
declare module '@sage/wh-stock/lib/nodes/transfer-movement-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class TransferMovementContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly transferNumber: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhStock.nodes.TransferMovement>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=transfer-movement-container-levels.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/stock-image.d.ts
declare module '@sage/wh-stock/lib/nodes/stock-image' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal } from '@sage/xtrem-core';
	export class StockImage extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly lotNumber: Promise<string>;
	    readonly quantityInStock: Promise<decimal | null>;
	    readonly quantityInPendingOutput: Promise<decimal | null>;
	    readonly quantityInPendingInput: Promise<decimal | null>;
	    readonly quantityReceivedButNotAddressed: Promise<decimal | null>;
	    readonly quantityPreparedButNotShipped: Promise<decimal | null>;
	    readonly quantityBlocked: Promise<decimal | null>;
	    readonly quantityInReserve: Promise<decimal | null>;
	    readonly quantityBlockedInPendingInput: Promise<decimal | null>;
	    readonly quantityBlockedInPendingOutput: Promise<decimal | null>;
	    readonly quantityReservedPendingInput: Promise<decimal | null>;
	    readonly quantityReservedPendingOutput: Promise<decimal | null>;
	    readonly quantityInBalanceForPreparation: Promise<decimal | null>;
	    readonly quantityReserveToBePrepared: Promise<decimal | null>;
	    readonly quantityExpected: Promise<decimal | null>;
	    readonly quantityInPendingAssembly: Promise<decimal | null>;
	    readonly stockUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
	}
	//# sourceMappingURL=stock-image.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/stock-count.d.ts
declare module '@sage/wh-stock/lib/nodes/stock-count' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class StockCount extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly reference: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.InventoryStatus | null>;
	    readonly isCreatedByOneCampaign: Promise<boolean>;
	    readonly stockCountCampaign: Reference<sageWhStock.nodes.StockCountCampaign | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly stockCountType: Promise<sageWhProductData.enums.InventoryType | null>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly isPendingStockCount: Promise<boolean>;
	    readonly maximumContainerLevel: Promise<sageWhMasterData.enums.ContainerLevel | null>;
	    readonly comments: Promise<string>;
	    readonly logFileNumber: Promise<string>;
	    readonly numberOfCounting: Promise<integer | null>;
	    readonly stockCountCreationOrigin: Promise<sageWhProductData.enums.StockCountCreationOrigin | null>;
	}
	//# sourceMappingURL=stock-count.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/stock-count-lines-by-product.d.ts
declare module '@sage/wh-stock/lib/nodes/stock-count-lines-by-product' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class StockCountLinesByProduct extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
	    readonly selection: Promise<integer | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly status: Promise<sageWhProductData.enums.InventoryLineType | null>;
	    readonly numberOfLocations: Promise<integer | null>;
	}
	//# sourceMappingURL=stock-count-lines-by-product.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/stock-count-lines-by-location.d.ts
declare module '@sage/wh-stock/lib/nodes/stock-count-lines-by-location' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class StockCountLinesByLocation extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
	    readonly selection: Promise<integer | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly status: Promise<sageWhProductData.enums.InventoryLineType | null>;
	    readonly numberOfProducts: Promise<integer | null>;
	}
	//# sourceMappingURL=stock-count-lines-by-location.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/stock-count-campaign.d.ts
declare module '@sage/wh-stock/lib/nodes/stock-count-campaign' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer } from '@sage/xtrem-core';
	export class StockCountCampaign extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly reference: Promise<string>;
	    readonly startDate: Promise<date | null>;
	    readonly endDate: Promise<date | null>;
	    readonly status: Promise<sageWhProductData.enums.InventoryStatus | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly numberOfStockCountsInProgress: Promise<integer | null>;
	    readonly numberOfStockCountsClosed: Promise<integer | null>;
	}
	//# sourceMappingURL=stock-count-campaign.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/simplified-stock-count.d.ts
declare module '@sage/wh-stock/lib/nodes/simplified-stock-count' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date } from '@sage/xtrem-core';
	export class SimplifiedStockCount extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly reference: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.SimplifiedStockCountStatus | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly closingDate: Promise<date | null>;
	}
	//# sourceMappingURL=simplified-stock-count.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/simplified-stock-count-line.d.ts
declare module '@sage/wh-stock/lib/nodes/simplified-stock-count-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class SimplifiedStockCountLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly simplifiedStockCount: Reference<sageWhStock.nodes.SimplifiedStockCount>;
	    readonly line: Promise<integer | null>;
	    readonly status: Promise<sageWhProductData.enums.SimplifiedStockCountStatus | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly enteredQuantity: Promise<decimal>;
	    readonly pendingInputQuantity: Promise<decimal | null>;
	    readonly pendingOutputQuantity: Promise<decimal | null>;
	    readonly expectedQuantity: Promise<decimal | null>;
	}
	//# sourceMappingURL=simplified-stock-count-line.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/serial-number-counting-line.d.ts
declare module '@sage/wh-stock/lib/nodes/serial-number-counting-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class SerialNumberCountingLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount>;
	    readonly counting: Reference<sageWhStock.nodes.Counting>;
	    readonly lineNumber: Promise<integer>;
	    readonly serialNumber: Promise<string>;
	    readonly double: Promise<integer | null>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly serialGroup: Promise<string>;
	    readonly parentGroup: Promise<string>;
	    readonly free1: Promise<string>;
	    readonly free2: Promise<string>;
	    readonly free3: Promise<string>;
	    readonly free4: Promise<string>;
	    readonly free5: Promise<string>;
	    readonly isNonExistentSerialNumber: Promise<boolean>;
	}
	//# sourceMappingURL=serial-number-counting-line.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/kit-declaration.d.ts
declare module '@sage/wh-stock/lib/nodes/kit-declaration' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class KitDeclaration extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder>;
	    readonly assemblyOrderLine: Reference<sageWhStock.nodes.AssemblingOrderLine>;
	    readonly kit: Reference<sageWhProductData.nodes.Product>;
	    readonly quantity: Promise<decimal | null>;
	    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave>;
	    readonly status: Promise<sageWhProductData.enums.AssemblyMovementStatus>;
	    readonly type: Promise<sageWhProductData.enums.Type>;
	    readonly postingDate: Promise<date | null>;
	    readonly validatingUser: Promise<string>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	}
	//# sourceMappingURL=kit-declaration.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/index.d.ts
declare module '@sage/wh-stock/lib/nodes/index' {
	export * from '@sage/wh-stock/lib/nodes/adjustment-movement-finals-and-initials-values';
	export * from '@sage/wh-stock/lib/nodes/adjustment-movement';
	export * from '@sage/wh-stock/lib/nodes/assembling-movement-container-levels';
	export * from '@sage/wh-stock/lib/nodes/assembling-movement';
	export * from '@sage/wh-stock/lib/nodes/assembling-order-line';
	export * from '@sage/wh-stock/lib/nodes/assembling-order';
	export * from '@sage/wh-stock/lib/nodes/assembling-wave';
	export * from '@sage/wh-stock/lib/nodes/count-line';
	export * from '@sage/wh-stock/lib/nodes/counting';
	export * from '@sage/wh-stock/lib/nodes/kit-declaration';
	export * from '@sage/wh-stock/lib/nodes/serial-number-counting-line';
	export * from '@sage/wh-stock/lib/nodes/simplified-stock-count-line';
	export * from '@sage/wh-stock/lib/nodes/simplified-stock-count';
	export * from '@sage/wh-stock/lib/nodes/stock-count-campaign';
	export * from '@sage/wh-stock/lib/nodes/stock-count-lines-by-location';
	export * from '@sage/wh-stock/lib/nodes/stock-count-lines-by-product';
	export * from '@sage/wh-stock/lib/nodes/stock-count';
	export * from '@sage/wh-stock/lib/nodes/stock-image';
	export * from '@sage/wh-stock/lib/nodes/transfer-movement-container-levels';
	export * from '@sage/wh-stock/lib/nodes/transfer-movement';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/counting.d.ts
declare module '@sage/wh-stock/lib/nodes/counting' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class Counting extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount>;
	    readonly code: Promise<integer>;
	    readonly reference: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.InventoryStatus | null>;
	    readonly countingType: Promise<sageWhProductData.enums.CountingType | null>;
	    readonly isProductWithoutStock: Promise<boolean>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly aisle: Promise<string>;
	    readonly row: Promise<string>;
	    readonly isPicking: Promise<boolean>;
	    readonly isReserve: Promise<boolean>;
	    readonly referenceCount1: Reference<sageWhStock.nodes.Counting | null>;
	    readonly referenceCount2: Reference<sageWhStock.nodes.Counting | null>;
	    readonly lineInError: Promise<sageWhProductData.enums.InventoryDiscrepancy | null>;
	    readonly comments: Promise<string>;
	    readonly date: Promise<date | null>;
	    readonly closingDate: Promise<date | null>;
	    readonly numberOfLines: Promise<integer | null>;
	}
	//# sourceMappingURL=counting.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/count-line.d.ts
declare module '@sage/wh-stock/lib/nodes/count-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class CountLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount>;
	    readonly counting: Reference<sageWhStock.nodes.Counting>;
	    readonly line: Promise<integer | null>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly isInput: Promise<boolean>;
	    readonly sort: Promise<string>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
	    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
	    readonly numberOfContainer: Promise<decimal | null>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly consumptionUnitQuantity: Promise<decimal | null>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly rowLevel: Promise<string>;
	    readonly travelSequence: Promise<string>;
	    readonly inventoryDiscrepancy: Promise<sageWhProductData.enums.InventoryDiscrepancy | null>;
	}
	//# sourceMappingURL=count-line.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/assembling-wave.d.ts
declare module '@sage/wh-stock/lib/nodes/assembling-wave' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
	export class AssemblingWave extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly type: Promise<sageWhProductData.enums.Type>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly numberOfAssemblyOrders: Promise<integer | null>;
	    readonly numberOfAssemblyOrderLines: Promise<integer | null>;
	    readonly numberOfReserveMovements: Promise<integer | null>;
	    readonly numberOfPickingMovements: Promise<integer | null>;
	    readonly numberOfIncompleteLines: Promise<integer | null>;
	    readonly numberOfReplenishmentMovements: Promise<integer | null>;
	    readonly numberOfTransferOrders: Promise<integer | null>;
	    readonly status: Promise<sageWhProductData.enums.WaveStatus | null>;
	    readonly volume: Promise<decimal | null>;
	    readonly weight: Promise<decimal | null>;
	    readonly numberOfTransferMovements: Promise<integer | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store>;
	    readonly location: Reference<sageWhMasterData.nodes.Location>;
	    readonly isAvailableStock: Promise<boolean>;
	    readonly isPickingStock: Promise<boolean>;
	    readonly isTransferIncomplete: Promise<boolean>;
	    readonly isMissionToBlock: Promise<boolean>;
	    readonly missionPriority: Promise<integer | null>;
	}
	//# sourceMappingURL=assembling-wave.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/assembling-order.d.ts
declare module '@sage/wh-stock/lib/nodes/assembling-order' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, Collection } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AssemblingOrder extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly reference: Promise<string>;
	    readonly type: Promise<sageWhProductData.enums.Type>;
	    readonly isUrgent: Promise<boolean>;
	    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
	    readonly status: Promise<sageWhProductData.enums.AssemblyOrderStatus>;
	    readonly date: Promise<date>;
	    readonly workOrderNumber: Promise<string>;
	    readonly workOrderDate: Promise<date | null>;
	    readonly plannedLaunchDate: Promise<date>;
	    readonly plannedLaunchTime: Promise<string>;
	    readonly plannedEndDate: Promise<date>;
	    readonly plannedEndTime: Promise<string>;
	    readonly transmittedByL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
	    readonly endProcessingDate: Promise<date | null>;
	    readonly endProcessingTime: Promise<string>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly lines: Collection<sageWhStock.nodes.AssemblingOrderLine>;
	}
	//# sourceMappingURL=assembling-order.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/assembling-order-line.d.ts
declare module '@sage/wh-stock/lib/nodes/assembling-order-line' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AssemblingOrderLine extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder>;
	    readonly lineNumber: Promise<integer>;
	    readonly status: Promise<sageWhProductData.enums.AssemblyOrderStatus | null>;
	    readonly date: Promise<date | null>;
	    readonly reference: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly lotNumber: Promise<string>;
	    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly numberOfContainer: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly totalQuantity: Promise<decimal>;
	    readonly launchedQuantity: Promise<decimal | null>;
	    readonly shortageQuantity: Promise<decimal | null>;
	    readonly declaredQuantity: Promise<decimal | null>;
	    readonly validatedQuantity: Promise<decimal | null>;
	    readonly launchDate: Promise<date | null>;
	    readonly launchTime: Promise<string>;
	    readonly endProcessingDate: Promise<date | null>;
	    readonly endProcessingTime: Promise<string>;
	    readonly kitDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
	    readonly numberOfKitQuantity: Promise<decimal | null>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly comments: Promise<string>;
	    readonly notes: Promise<string>;
	    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
	    readonly flowNumber: Promise<integer | null>;
	}
	//# sourceMappingURL=assembling-order-line.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/assembling-movement.d.ts
declare module '@sage/wh-stock/lib/nodes/assembling-movement' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AssemblingMovement extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder | null>;
	    readonly assemblyOrderLineNumber: Promise<integer | null>;
	    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave>;
	    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly numberOfContainer: Promise<decimal>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal | null>;
	    readonly consumptionUnitQuantity: Promise<decimal>;
	    readonly numberOfKits: Promise<decimal | null>;
	    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
	    readonly lotNumber: Promise<string>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly status: Promise<sageWhProductData.enums.AssemblyMovementStatus | null>;
	    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly fifoDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly store: Reference<sageWhMasterData.nodes.Store>;
	    readonly location: Reference<sageWhMasterData.nodes.Location>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly replenishment: Reference<sageWhStock.nodes.TransferMovement | null>;
	    readonly transfer: Reference<sageWhStock.nodes.TransferMovement | null>;
	    readonly adjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
	    readonly kitDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
	    readonly isKitTransferAuthorized: Promise<boolean>;
	    readonly flowNumber: Promise<integer | null>;
	    readonly containerNumber: Promise<string>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly originQuantity: Promise<decimal | null>;
	    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
	    readonly validatingUser: Promise<string>;
	    readonly postingDate: Promise<date | null>;
	    readonly postingTime: Promise<integer | null>;
	    readonly containerLevels: Collection<sageWhStock.nodes.AssemblingMovementContainerLevels>;
	}
	//# sourceMappingURL=assembling-movement.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/assembling-movement-container-levels.d.ts
declare module '@sage/wh-stock/lib/nodes/assembling-movement-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AssemblingMovementContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhStock.nodes.AssemblingMovement>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=assembling-movement-container-levels.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/adjustment-movement.d.ts
declare module '@sage/wh-stock/lib/nodes/adjustment-movement' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhStockData from '@sage/wh-stock-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AdjustmentMovement extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly code: Promise<string>;
	    readonly date: Promise<date>;
	    readonly time: Promise<string>;
	    readonly movement: Reference<sageWhMasterData.nodes.MovementCode>;
	    readonly movementType: Promise<sageWhMasterData.enums.AdjustmentType | null>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly store: Reference<sageWhMasterData.nodes.Store>;
	    readonly location: Reference<sageWhMasterData.nodes.Location>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject>;
	    readonly containerNumber: Promise<string>;
	    readonly stockObjectLinkNumber: Promise<string>;
	    readonly adjustmentQuantity: Promise<decimal | null>;
	    readonly adjustmentContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly adjustmentConsumptionUnitQuantity: Promise<decimal | null>;
	    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
	    readonly isKeyInSerialNumber: Promise<boolean>;
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
	    readonly counting: Reference<sageWhStock.nodes.Counting | null>;
	    readonly countingLine: Reference<sageWhStock.nodes.CountLine | null>;
	    readonly assemblyDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
	    readonly transfer: Reference<sageWhStock.nodes.TransferMovement | null>;
	    readonly movementTransfer: Reference<sageWhStock.nodes.TransferMovement | null>;
	    readonly adjustmentComment: Promise<string>;
	    readonly finalsAndInitialsValues: Collection<sageWhStock.nodes.AdjustmentMovementFinalsAndInitialsValues>;
	}
	//# sourceMappingURL=adjustment-movement.d.ts.map
}
// From file: @sage/wh-stock/build/lib/nodes/adjustment-movement-finals-and-initials-values.d.ts
declare module '@sage/wh-stock/lib/nodes/adjustment-movement-finals-and-initials-values' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal, date } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class AdjustmentMovementFinalsAndInitialsValues extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly depositor: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhStock.nodes.AdjustmentMovement>;
	    readonly consumptionUnitQuantity: Promise<decimal | null>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly homogeneousQuantity: Promise<decimal | null>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly numberOfContainer: Promise<decimal | null>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly fifoDate: Promise<date | null>;
	}
	//# sourceMappingURL=adjustment-movement-finals-and-initials-values.d.ts.map
}
// From file: @sage/wh-stock/build/lib/node-extensions/stock-object-extension.d.ts
declare module '@sage/wh-stock/lib/node-extensions/stock-object-extension' {
	import * as sageWhStockData from '@sage/wh-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class StockObjectExtension extends NodeExtension<sageWhStockData.nodes.StockObject> {
	    readonly adjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
	}
	declare module '@sage/wh-stock-data/lib/nodes/stock-object' {
	    interface StockObject extends StockObjectExtension {
	    }
	}
	//# sourceMappingURL=stock-object-extension.d.ts.map
}
// From file: @sage/wh-stock/build/lib/node-extensions/serial-number-extension.d.ts
declare module '@sage/wh-stock/lib/node-extensions/serial-number-extension' {
	import * as sageWhStockData from '@sage/wh-stock-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class SerialNumberExtension extends NodeExtension<sageWhStockData.nodes.SerialNumber> {
	    readonly inputAdjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
	    readonly outputAdjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
	    readonly transfer: Reference<sageWhStock.nodes.TransferMovement | null>;
	    readonly transferMovement: Reference<sageWhStock.nodes.TransferMovement | null>;
	}
	declare module '@sage/wh-stock-data/lib/nodes/serial-number' {
	    interface SerialNumber extends SerialNumberExtension {
	    }
	}
	//# sourceMappingURL=serial-number-extension.d.ts.map
}
// From file: @sage/wh-stock/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/wh-stock/lib/node-extensions/product-extension' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class ProductExtension extends NodeExtension<sageWhProductData.nodes.Product> {
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
	}
	declare module '@sage/wh-product-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: @sage/wh-stock/build/lib/node-extensions/location-extension.d.ts
declare module '@sage/wh-stock/lib/node-extensions/location-extension' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import { NodeExtension, Reference } from '@sage/xtrem-core';
	import * as sageWhStock from '@sage/wh-stock/lib/index';
	export class LocationExtension extends NodeExtension<sageWhMasterData.nodes.Location> {
	    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
	}
	declare module '@sage/wh-master-data/lib/nodes/location' {
	    interface Location extends LocationExtension {
	    }
	}
	//# sourceMappingURL=location-extension.d.ts.map
}
// From file: @sage/wh-stock/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-stock/lib/node-extensions/index' {
	export * from '@sage/wh-stock/lib/node-extensions/location-extension';
	export * from '@sage/wh-stock/lib/node-extensions/product-extension';
	export * from '@sage/wh-stock/lib/node-extensions/serial-number-extension';
	export * from '@sage/wh-stock/lib/node-extensions/stock-object-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock/build/lib/enums/index.d.ts
declare module '@sage/wh-stock/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/wh-stock' {
	export * from '@sage/wh-stock/index';
}
