import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStockData from '@sage/wh-stock-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class TransferMovement extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly transferNumber: Promise<string>;
    readonly code: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly assemblingWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
    readonly subWaveNumber: Promise<integer | null>;
    readonly adjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly containerNumber: Promise<string>;
    readonly originStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly originAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly sourceProduct: Reference<sageWhProductData.nodes.Product>;
    readonly originStockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly originQuantity: Promise<decimal | null>;
    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
    readonly numberOfContainer: Promise<decimal | null>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly numberOfConsumptionUnit: Promise<decimal | null>;
    readonly level: Promise<sageWhMasterData.enums.ContainerLevel | null>;
    readonly status: Promise<sageWhProductData.enums.ReplenishmentMovementType | null>;
    readonly movementType: Promise<sageWhProductData.enums.MovementType | null>;
    readonly masterStockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly masterContainerNumber: Promise<string>;
    readonly masterProduct: Reference<sageWhProductData.nodes.Product | null>;
    readonly date: Promise<date | null>;
    readonly time: Promise<string>;
    readonly homogeneousQuantity: Promise<decimal | null>;
    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly homogeneousContainerCoefficient: Promise<decimal | null>;
    readonly receiptDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly fifoDate: Promise<date | null>;
    readonly lotNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly reservationNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly sortPreparationOrder: Promise<string>;
    readonly rowLevel: Promise<string>;
    readonly travelSequence: Promise<string>;
    readonly transferObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly transferStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly transferAddress: Reference<sageWhMasterData.nodes.Location | null>;
    readonly position: Promise<integer | null>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly validatingUser: Promise<string>;
    readonly postingDate: Promise<date | null>;
    readonly postingTime: Promise<integer | null>;
    readonly flowNumber: Promise<integer | null>;
    readonly pickingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly pickingUser: Promise<string>;
    readonly pickingDate: Promise<date | null>;
    readonly pickingTime: Promise<integer | null>;
    readonly groupingCode: Promise<string>;
    readonly depositObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly depositStore: Reference<sageWhMasterData.nodes.Store | null>;
    readonly depositLocation: Reference<sageWhMasterData.nodes.Location | null>;
    readonly containerLevels: Collection<sageWhStock.nodes.TransferMovementContainerLevels>;
}
//# sourceMappingURL=transfer-movement.d.ts.map