"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockImage = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        stockStatus: {
            site: 'site',
            code: 'stockStatus',
        },
        stockUnit: {
            code: 'stockUnit',
        },
    },
};
let StockImage = class StockImage extends xtrem_core_1.Node {
};
exports.StockImage = StockImage;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], StockImage.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], StockImage.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], StockImage.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKN',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.StockNature,
        lookupAccess: true,
    })
], StockImage.prototype, "stockStatus", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LOT',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "lotNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInStock", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PDO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInPendingOutput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PDI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInPendingInput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RCP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityReceivedButNotAddressed", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NSHPIK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityPreparedButNotShipped", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOKSKQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityBlocked", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSASKQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInReserve", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOKPDI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityBlockedInPendingInput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LOKPDO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityBlockedInPendingOutput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSAPDI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityReservedPendingInput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSAPDO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityReservedPendingOutput", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BLCPIK',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInBalanceForPreparation", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RSABLC',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityReserveToBePrepared", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'EINEXP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityExpected", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'BOMEXP',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], StockImage.prototype, "quantityInPendingAssembly", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STU',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.UnitOfMeasure,
        lookupAccess: true,
    })
], StockImage.prototype, "stockUnit", void 0);
exports.StockImage = StockImage = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'INTSKO',
        keyPropertyNames: ['site', 'depositor', 'product', 'stockStatus', 'lotNumber'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    product: 1,
                    stockStatus: 1,
                    lotNumber: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['stockStatus'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockImage);
//# sourceMappingURL=stock-image.js.map