import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal } from '@sage/xtrem-core';
export declare class StockImage extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly lotNumber: Promise<string>;
    readonly quantityInStock: Promise<decimal | null>;
    readonly quantityInPendingOutput: Promise<decimal | null>;
    readonly quantityInPendingInput: Promise<decimal | null>;
    readonly quantityReceivedButNotAddressed: Promise<decimal | null>;
    readonly quantityPreparedButNotShipped: Promise<decimal | null>;
    readonly quantityBlocked: Promise<decimal | null>;
    readonly quantityInReserve: Promise<decimal | null>;
    readonly quantityBlockedInPendingInput: Promise<decimal | null>;
    readonly quantityBlockedInPendingOutput: Promise<decimal | null>;
    readonly quantityReservedPendingInput: Promise<decimal | null>;
    readonly quantityReservedPendingOutput: Promise<decimal | null>;
    readonly quantityInBalanceForPreparation: Promise<decimal | null>;
    readonly quantityReserveToBePrepared: Promise<decimal | null>;
    readonly quantityExpected: Promise<decimal | null>;
    readonly quantityInPendingAssembly: Promise<decimal | null>;
    readonly stockUnit: Reference<sageWhMasterData.nodes.UnitOfMeasure | null>;
}
//# sourceMappingURL=stock-image.d.ts.map