"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountLinesByProduct = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        stockCount: {
            site: 'site',
            code: 'stockCount',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
    },
};
let StockCountLinesByProduct = class StockCountLinesByProduct extends xtrem_core_1.Node {
};
exports.StockCountLinesByProduct = StockCountLinesByProduct;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.StockCount,
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "stockCount", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SEL',
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "selection", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKISTA',
        dataType: () => sageWhProductData.enums.inventoryLineTypeDatatype,
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBR',
        lookupAccess: true,
    })
], StockCountLinesByProduct.prototype, "numberOfLocations", void 0);
exports.StockCountLinesByProduct = StockCountLinesByProduct = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SKCITM',
        keyPropertyNames: ['site', 'stockCount', 'selection', 'depositor', 'product'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    stockCount: 1,
                    selection: 1,
                    depositor: 1,
                    product: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['stockCount', 'selection', 'depositor', 'product'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockCountLinesByProduct);
//# sourceMappingURL=stock-count-lines-by-product.js.map