"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.StockCountLinesByLocation = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        stockCount: {
            site: 'site',
            code: 'stockCount',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        location: {
            site: 'site',
            store: 'store',
            code: 'location',
        },
    },
};
let StockCountLinesByLocation = class StockCountLinesByLocation extends xtrem_core_1.Node {
};
exports.StockCountLinesByLocation = StockCountLinesByLocation;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.StockCount,
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "stockCount", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SEL',
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "selection", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKSSTA',
        dataType: () => sageWhProductData.enums.inventoryLineTypeDatatype,
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBR',
        lookupAccess: true,
    })
], StockCountLinesByLocation.prototype, "numberOfProducts", void 0);
exports.StockCountLinesByLocation = StockCountLinesByLocation = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'SKCSLO',
        keyPropertyNames: ['site', 'stockCount', 'selection', 'store', 'location'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    stockCount: 1,
                    selection: 1,
                    store: 1,
                    location: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['stockCount', 'selection', 'store', 'location'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], StockCountLinesByLocation);
//# sourceMappingURL=stock-count-lines-by-location.js.map