"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimplifiedStockCountLine = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        simplifiedStockCount: {
            site: 'site',
            code: 'simplifiedStockCount',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        homogeneousContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'homogeneousContainer',
        },
    },
};
let SimplifiedStockCountLine = class SimplifiedStockCountLine extends xtrem_core_1.Node {
};
exports.SimplifiedStockCountLine = SimplifiedStockCountLine;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SSHNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.SimplifiedStockCount,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "simplifiedStockCount", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPTLIG',
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "line", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SSHSTA',
        dataType: () => sageWhProductData.enums.simplifiedStockCountStatusDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "homogeneousQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'HMGCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "homogeneousContainer", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CSUQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "enteredQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PDI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "pendingInputQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PDO',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "pendingOutputQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLOQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], SimplifiedStockCountLine.prototype, "expectedQuantity", void 0);
exports.SimplifiedStockCountLine = SimplifiedStockCountLine = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STKCOUNSC',
        keyPropertyNames: ['site', 'simplifiedStockCount', 'line'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    simplifiedStockCount: 1,
                    line: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
            joinFallbackProperties: ['line'],
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SimplifiedStockCountLine);
//# sourceMappingURL=simplified-stock-count-line.js.map