"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KitDeclaration = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        assemblyOrder: {
            site: 'site',
            depositor: 'depositor',
            code: 'assemblyOrder',
        },
        assemblyOrderLine: {
            site: 'site',
            depositor: 'depositor',
            assemblyOrder: 'assemblyOrder',
            lineNumber: 'assemblyOrderLine',
        },
        kit: {
            site: 'site',
            depositor: 'depositor',
            code: 'kit',
        },
        assemblyWave: {
            site: 'site',
            depositor: 'depositor',
            code: 'assemblyWave',
        },
        validatingOperator: {
            site: 'site',
            code: 'validatingOperator',
        },
    },
};
let KitDeclaration = class KitDeclaration extends xtrem_core_1.Node {
};
exports.KitDeclaration = KitDeclaration;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'DCLNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.AssemblingOrder,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "assemblyOrder", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BOMLIN',
        columnType: 'integer',
        node: () => sageWhStock.nodes.AssemblingOrderLine,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "assemblyOrderLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "kit", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CUQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "quantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WAVNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.AssemblingWave,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "assemblyWave", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLSTA',
        dataType: () => sageWhProductData.enums.assemblyMovementStatusDatatype,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DCLTYP',
        dataType: () => sageWhProductData.enums.typeDatatype,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], KitDeclaration.prototype, "postingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'VLDUSR',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "validatingUser", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'VLDOPE',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Operand,
        lookupAccess: true,
    })
], KitDeclaration.prototype, "validatingOperator", void 0);
exports.KitDeclaration = KitDeclaration = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'DCLBOM',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], KitDeclaration);
//# sourceMappingURL=kit-declaration.js.map