import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, date } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class KitDeclaration extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder>;
    readonly assemblyOrderLine: Reference<sageWhStock.nodes.AssemblingOrderLine>;
    readonly kit: Reference<sageWhProductData.nodes.Product>;
    readonly quantity: Promise<decimal | null>;
    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave>;
    readonly status: Promise<sageWhProductData.enums.AssemblyMovementStatus>;
    readonly type: Promise<sageWhProductData.enums.Type>;
    readonly postingDate: Promise<date | null>;
    readonly validatingUser: Promise<string>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
}
//# sourceMappingURL=kit-declaration.d.ts.map