"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Counting = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        stockCount: {
            site: 'site',
            code: 'stockCount',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        referenceCount1: {
            site: 'site',
            stockCount: 'stockCount',
            code: 'referenceCount1',
        },
        referenceCount2: {
            site: 'site',
            stockCount: 'stockCount',
            code: 'referenceCount2',
        },
    },
};
let Counting = class Counting extends xtrem_core_1.Node {
};
exports.Counting = Counting;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], Counting.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKCNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.StockCount,
        lookupAccess: true,
    })
], Counting.prototype, "stockCount", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        columnName: 'CPTNUM',
        lookupAccess: true,
    })
], Counting.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKCREF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "reference", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCSTA',
        dataType: () => sageWhProductData.enums.inventoryStatusDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCTYP',
        dataType: () => sageWhProductData.enums.countingTypeDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "countingType", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'WIOSLO',
        lookupAccess: true,
    })
], Counting.prototype, "isProductWithoutStock", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], Counting.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AIS',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "aisle", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ROW',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "row", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PIC',
        lookupAccess: true,
    })
], Counting.prototype, "isPicking", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'RSV',
        lookupAccess: true,
    })
], Counting.prototype, "isReserve", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEVCPT2',
        columnType: 'integer',
        node: () => sageWhStock.nodes.Counting,
        lookupAccess: true,
    })
], Counting.prototype, "referenceCount1", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEVCPT3',
        columnType: 'integer',
        node: () => sageWhStock.nodes.Counting,
        lookupAccess: true,
    })
], Counting.prototype, "referenceCount2", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DEVSKD',
        dataType: () => sageWhProductData.enums.inventoryDiscrepancyDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "lineInError", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], Counting.prototype, "comments", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Counting.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CLODAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], Counting.prototype, "closingDate", void 0);
__decorate([
    xtrem_core_1.decorators.integerProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'NBRLIG',
        lookupAccess: true,
    })
], Counting.prototype, "numberOfLines", void 0);
exports.Counting = Counting = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'STKCOUNTC',
        keyPropertyNames: ['site', 'stockCount', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    stockCount: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], Counting);
//# sourceMappingURL=counting.js.map