import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, date } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class Counting extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly stockCount: Reference<sageWhStock.nodes.StockCount>;
    readonly code: Promise<integer>;
    readonly reference: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.InventoryStatus | null>;
    readonly countingType: Promise<sageWhProductData.enums.CountingType | null>;
    readonly isProductWithoutStock: Promise<boolean>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly aisle: Promise<string>;
    readonly row: Promise<string>;
    readonly isPicking: Promise<boolean>;
    readonly isReserve: Promise<boolean>;
    readonly referenceCount1: Reference<sageWhStock.nodes.Counting | null>;
    readonly referenceCount2: Reference<sageWhStock.nodes.Counting | null>;
    readonly lineInError: Promise<sageWhProductData.enums.InventoryDiscrepancy | null>;
    readonly comments: Promise<string>;
    readonly date: Promise<date | null>;
    readonly closingDate: Promise<date | null>;
    readonly numberOfLines: Promise<integer | null>;
}
//# sourceMappingURL=counting.d.ts.map