import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class CountLine extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly stockCount: Reference<sageWhStock.nodes.StockCount>;
    readonly counting: Reference<sageWhStock.nodes.Counting>;
    readonly line: Promise<integer | null>;
    readonly isKeyInSerialNumber: Promise<boolean>;
    readonly isInput: Promise<boolean>;
    readonly sort: Promise<string>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor | null>;
    readonly product: Reference<sageWhProductData.nodes.Product | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store | null>;
    readonly location: Reference<sageWhMasterData.nodes.Location | null>;
    readonly numberOfContainer: Promise<decimal | null>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly consumptionUnitQuantity: Promise<decimal | null>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly reservationNumber: Promise<string>;
    readonly lotNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
    readonly fifoDate: Promise<date | null>;
    readonly receiptDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly rowLevel: Promise<string>;
    readonly travelSequence: Promise<string>;
    readonly inventoryDiscrepancy: Promise<sageWhProductData.enums.InventoryDiscrepancy | null>;
}
//# sourceMappingURL=count-line.d.ts.map