import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, integer, decimal } from '@sage/xtrem-core';
export declare class AssemblingWave extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly type: Promise<sageWhProductData.enums.Type>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly numberOfAssemblyOrders: Promise<integer | null>;
    readonly numberOfAssemblyOrderLines: Promise<integer | null>;
    readonly numberOfReserveMovements: Promise<integer | null>;
    readonly numberOfPickingMovements: Promise<integer | null>;
    readonly numberOfIncompleteLines: Promise<integer | null>;
    readonly numberOfReplenishmentMovements: Promise<integer | null>;
    readonly numberOfTransferOrders: Promise<integer | null>;
    readonly status: Promise<sageWhProductData.enums.WaveStatus | null>;
    readonly volume: Promise<decimal | null>;
    readonly weight: Promise<decimal | null>;
    readonly numberOfTransferMovements: Promise<integer | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store>;
    readonly location: Reference<sageWhMasterData.nodes.Location>;
    readonly isAvailableStock: Promise<boolean>;
    readonly isPickingStock: Promise<boolean>;
    readonly isTransferIncomplete: Promise<boolean>;
    readonly isMissionToBlock: Promise<boolean>;
    readonly missionPriority: Promise<integer | null>;
}
//# sourceMappingURL=assembling-wave.d.ts.map