"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AssemblingOrder = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        movementCode: {
            site: 'site',
            code: 'movementCode',
        },
        assemblyWave: {
            site: 'site',
            depositor: 'depositor',
            code: 'assemblyWave',
        },
    },
    collectionJoins: {
        lines: {
            site: 'site',
            depositor: 'depositor',
            assemblyOrder: 'code',
        },
    },
};
let AssemblingOrder = class AssemblingOrder extends xtrem_core_1.Node {
};
exports.AssemblingOrder = AssemblingOrder;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'BOMNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'REF',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "reference", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BMHTYP',
        dataType: () => sageWhProductData.enums.typeDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "type", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'URG',
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "isUrgent", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PIR',
        dataType: () => sageWhMasterData.enums.servicePriorityDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "servicePriority", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'BMHSTA',
        dataType: () => sageWhProductData.enums.assemblyOrderStatusDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "status", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ASBNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "workOrderNumber", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ASBDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "workOrderDate", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXPLNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "plannedLaunchDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'EXPLNCTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "plannedLaunchTime", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'EXPENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "plannedEndDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'EXPENDTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "plannedEndTime", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'TRM',
        dataType: () => sageWhProductData.enums.transmissionL3Datatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "transmittedByL3", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ENDDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "endProcessingDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ENDTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "endProcessingTime", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "movementCode", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'WAVNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.AssemblingWave,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "assemblyWave", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'LNCDAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "launchDate", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LNCTIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "launchTime", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        node: () => sageWhStock.nodes.AssemblingOrderLine,
        isMutable: true,
        dependsOn: ['site', 'depositor', 'code'],
        lookupAccess: true,
    })
], AssemblingOrder.prototype, "lines", void 0);
exports.AssemblingOrder = AssemblingOrder = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'BOMORDERH',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AssemblingOrder);
//# sourceMappingURL=assembling-order.js.map