import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, Collection } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class AssemblingOrder extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly reference: Promise<string>;
    readonly type: Promise<sageWhProductData.enums.Type>;
    readonly isUrgent: Promise<boolean>;
    readonly servicePriority: Promise<sageWhMasterData.enums.ServicePriority | null>;
    readonly status: Promise<sageWhProductData.enums.AssemblyOrderStatus>;
    readonly date: Promise<date>;
    readonly workOrderNumber: Promise<string>;
    readonly workOrderDate: Promise<date | null>;
    readonly plannedLaunchDate: Promise<date>;
    readonly plannedLaunchTime: Promise<string>;
    readonly plannedEndDate: Promise<date>;
    readonly plannedEndTime: Promise<string>;
    readonly transmittedByL3: Promise<sageWhProductData.enums.TransmissionL3 | null>;
    readonly endProcessingDate: Promise<date | null>;
    readonly endProcessingTime: Promise<string>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly lines: Collection<sageWhStock.nodes.AssemblingOrderLine>;
}
//# sourceMappingURL=assembling-order.d.ts.map