import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, date, decimal } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class AssemblingOrderLine extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder>;
    readonly lineNumber: Promise<integer>;
    readonly status: Promise<sageWhProductData.enums.AssemblyOrderStatus | null>;
    readonly date: Promise<date | null>;
    readonly reference: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly lotNumber: Promise<string>;
    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly numberOfContainer: Promise<decimal>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly totalQuantity: Promise<decimal>;
    readonly launchedQuantity: Promise<decimal | null>;
    readonly shortageQuantity: Promise<decimal | null>;
    readonly declaredQuantity: Promise<decimal | null>;
    readonly validatedQuantity: Promise<decimal | null>;
    readonly launchDate: Promise<date | null>;
    readonly launchTime: Promise<string>;
    readonly endProcessingDate: Promise<date | null>;
    readonly endProcessingTime: Promise<string>;
    readonly kitDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
    readonly numberOfKitQuantity: Promise<decimal | null>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly comments: Promise<string>;
    readonly notes: Promise<string>;
    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave | null>;
    readonly flowNumber: Promise<integer | null>;
}
//# sourceMappingURL=assembling-order-line.d.ts.map