import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStockData from '@sage/wh-stock-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, integer, decimal, date, Collection } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class AssemblingMovement extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly assemblyOrder: Reference<sageWhStock.nodes.AssemblingOrder | null>;
    readonly assemblyOrderLineNumber: Promise<integer | null>;
    readonly assemblyWave: Reference<sageWhStock.nodes.AssemblingWave>;
    readonly lineType: Promise<sageWhProductData.enums.DoLineType | null>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly numberOfContainer: Promise<decimal>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousContainerCoefficient: Promise<decimal | null>;
    readonly consumptionUnitQuantity: Promise<decimal>;
    readonly numberOfKits: Promise<decimal | null>;
    readonly movementCode: Reference<sageWhMasterData.nodes.MovementCode | null>;
    readonly lotNumber: Promise<string>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly reservationNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly status: Promise<sageWhProductData.enums.AssemblyMovementStatus | null>;
    readonly originSource: Reference<sageWhProductData.nodes.Origin | null>;
    readonly receiptDate: Promise<date | null>;
    readonly fifoDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly store: Reference<sageWhMasterData.nodes.Store>;
    readonly location: Reference<sageWhMasterData.nodes.Location>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
    readonly replenishment: Reference<sageWhStock.nodes.TransferMovement | null>;
    readonly transfer: Reference<sageWhStock.nodes.TransferMovement | null>;
    readonly adjustment: Reference<sageWhStock.nodes.AdjustmentMovement | null>;
    readonly kitDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
    readonly isKitTransferAuthorized: Promise<boolean>;
    readonly flowNumber: Promise<integer | null>;
    readonly containerNumber: Promise<string>;
    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousQuantity: Promise<decimal>;
    readonly originContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly originQuantity: Promise<decimal | null>;
    readonly validatingOperator: Reference<sageWhMasterData.nodes.Operand | null>;
    readonly validatingUser: Promise<string>;
    readonly postingDate: Promise<date | null>;
    readonly postingTime: Promise<integer | null>;
    readonly containerLevels: Collection<sageWhStock.nodes.AssemblingMovementContainerLevels>;
}
//# sourceMappingURL=assembling-movement.d.ts.map