"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdjustmentMovement = void 0;
const sageWhMasterData = require("@sage/wh-master-data");
const sageWhProductData = require("@sage/wh-product-data");
const sageWhStockData = require("@sage/wh-stock-data");
const sageWhSystem = require("@sage/wh-system");
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageWhStock = require("..");
const joins = {
    referenceJoins: {
        site: {
            code: 'site',
        },
        depositor: {
            site: 'site',
            code: 'depositor',
        },
        movement: {
            site: 'site',
            code: 'movement',
        },
        product: {
            site: 'site',
            depositor: 'depositor',
            code: 'product',
        },
        store: {
            site: 'site',
            code: 'store',
        },
        location: {
            site: 'site',
            store: 'store',
            code: 'location',
        },
        stockObject: {
            site: 'site',
            code: 'stockObject',
        },
        adjustmentContainer: {
            site: 'site',
            depositor: 'depositor',
            product: 'product',
            container: 'adjustmentContainer',
        },
        stockCount: {
            site: 'site',
            code: 'stockCount',
        },
        counting: {
            site: 'site',
            stockCount: 'stockCount',
            code: 'counting',
        },
        countingLine: {
            site: 'site',
            stockCount: 'stockCount',
            counting: 'counting',
            line: 'countingLine',
        },
        assemblyDeclaration: {
            site: 'site',
            depositor: 'depositor',
            code: 'assemblyDeclaration',
        },
        transfer: {
            site: 'site',
            depositor: 'depositor',
            transferNumber: 'transfer',
            code: 'movementTransfer',
        },
        movementTransfer: {
            site: 'site',
            depositor: 'depositor',
            transferNumber: 'transfer',
            code: 'movementTransfer',
        },
    },
};
let AdjustmentMovement = class AdjustmentMovement extends xtrem_core_1.Node {
};
exports.AdjustmentMovement = AdjustmentMovement;
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'FCY',
        columnType: 'string',
        node: () => sageWhSystem.nodes.Site,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "site", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DEP',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Depositor,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "depositor", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'ADJNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "code", void 0);
__decorate([
    xtrem_core_1.decorators.dateProperty({
        isPublished: true,
        isStored: true,
        columnName: 'DAT',
        defaultValue() {
            return xtrem_x3_gateway_1.X3StorageManager.getDateDefaultValue(this);
        },
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "date", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'TIM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "time", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'MVT',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.MovementCode,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "movement", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADJTYP',
        dataType: () => sageWhMasterData.enums.adjustmentTypeDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "movementType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'ITM',
        columnType: 'string',
        node: () => sageWhProductData.nodes.Product,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "product", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'STO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Store,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "store", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SLO',
        columnType: 'string',
        node: () => sageWhMasterData.nodes.Location,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "location", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SLOTYP',
        dataType: () => sageWhMasterData.enums.locationTypeDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "locationType", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKONUM',
        columnType: 'string',
        node: () => sageWhStockData.nodes.StockObject,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "stockObject", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CTRLIKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "containerNumber", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SKOLIKNUM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "stockObjectLinkNumber", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADJQTY',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "adjustmentQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADJCTR',
        columnType: 'string',
        node: () => sageWhProductData.nodes.ProductContainer,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "adjustmentContainer", void 0);
__decorate([
    xtrem_core_1.decorators.decimalProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'ADJCUQ',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.decimalDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "adjustmentConsumptionUnitQuantity", void 0);
__decorate([
    xtrem_core_1.decorators.enumProperty({
        isPublished: true,
        isStored: true,
        columnName: 'LVL',
        dataType: () => sageWhMasterData.enums.containerLevelDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "level", void 0);
__decorate([
    xtrem_core_1.decorators.booleanProperty({
        isPublished: true,
        isStored: true,
        columnName: 'SRNMGT',
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "isKeyInSerialNumber", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'SKCNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.StockCount,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "stockCount", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPTNUM',
        columnType: 'integer',
        node: () => sageWhStock.nodes.Counting,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "counting", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'CPTLIG',
        columnType: 'integer',
        node: () => sageWhStock.nodes.CountLine,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "countingLine", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'DCLNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.KitDeclaration,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "assemblyDeclaration", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'RPNNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.TransferMovement,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "transfer", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'MVTNUM',
        columnType: 'string',
        node: () => sageWhStock.nodes.TransferMovement,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "movementTransfer", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'AJMREM',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        lookupAccess: true,
    })
], AdjustmentMovement.prototype, "adjustmentComment", void 0);
__decorate([
    xtrem_core_1.decorators.collectionProperty({
        isPublished: true,
        isVital: true,
        reverseReference: '_denormalizedParent',
        node: () => sageWhStock.nodes.AdjustmentMovementFinalsAndInitialsValues,
    })
], AdjustmentMovement.prototype, "finalsAndInitialsValues", void 0);
exports.AdjustmentMovement = AdjustmentMovement = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'ADJUSTM',
        keyPropertyNames: ['site', 'depositor', 'code'],
        indexes: [
            {
                orderBy: {
                    site: 1,
                    depositor: 1,
                    code: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], AdjustmentMovement);
//# sourceMappingURL=adjustment-movement.js.map