import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhStockData from '@sage/wh-stock-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, date, decimal, Collection } from '@sage/xtrem-core';
import * as sageWhStock from '..';
export declare class AdjustmentMovement extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly code: Promise<string>;
    readonly date: Promise<date>;
    readonly time: Promise<string>;
    readonly movement: Reference<sageWhMasterData.nodes.MovementCode>;
    readonly movementType: Promise<sageWhMasterData.enums.AdjustmentType | null>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly store: Reference<sageWhMasterData.nodes.Store>;
    readonly location: Reference<sageWhMasterData.nodes.Location>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType | null>;
    readonly stockObject: Reference<sageWhStockData.nodes.StockObject>;
    readonly containerNumber: Promise<string>;
    readonly stockObjectLinkNumber: Promise<string>;
    readonly adjustmentQuantity: Promise<decimal | null>;
    readonly adjustmentContainer: Reference<sageWhProductData.nodes.ProductContainer | null>;
    readonly adjustmentConsumptionUnitQuantity: Promise<decimal | null>;
    readonly level: Promise<sageWhMasterData.enums.ContainerLevel>;
    readonly isKeyInSerialNumber: Promise<boolean>;
    readonly stockCount: Reference<sageWhStock.nodes.StockCount | null>;
    readonly counting: Reference<sageWhStock.nodes.Counting | null>;
    readonly countingLine: Reference<sageWhStock.nodes.CountLine | null>;
    readonly assemblyDeclaration: Reference<sageWhStock.nodes.KitDeclaration | null>;
    readonly transfer: Reference<sageWhStock.nodes.TransferMovement | null>;
    readonly movementTransfer: Reference<sageWhStock.nodes.TransferMovement | null>;
    readonly adjustmentComment: Promise<string>;
    readonly finalsAndInitialsValues: Collection<sageWhStock.nodes.AdjustmentMovementFinalsAndInitialsValues>;
}
//# sourceMappingURL=adjustment-movement.d.ts.map