declare module '@sage/wh-stock-api-partial' {
    import type {
        AssignmentClass,
        Depositor,
        Location,
        LocationInput,
        LocationSplitAddresses,
        LocationSplitAddressesBinding,
        LocationSplitAddressesInput,
        MovementCode,
        Operand,
        Package as SageWhMasterData$Package,
        RotationClass,
        SerialGroup,
        StockCountClass,
        StockNature,
        StorageType,
        Store,
        UnitOfMeasure,
    } from '@sage/wh-master-data-api';
    import type {
        Container,
        Family,
        Group,
        HazardousMaterialsClass,
        IcpeClasses,
        InputMode,
        OnuCode,
        Origin,
        OutputMode,
        Package as SageWhProductData$Package,
        Product,
        ProductActiveMatters,
        ProductActiveMattersBinding,
        ProductActiveMattersInput,
        ProductContainer,
        ProductInput,
        ProductIsPrintableDescriptions,
        ProductIsPrintableDescriptionsBinding,
        ProductIsPrintableDescriptionsInput,
        ProductPercentageActiveMatters,
        ProductPercentageActiveMattersBinding,
        ProductPercentageActiveMattersInput,
        Risk,
        SubFamily,
        SubGroup,
        SupplierUpc,
        TransportCategory,
    } from '@sage/wh-product-data-api';
    import type {
        Package as SageWhStockData$Package,
        SerialNumber,
        SerialNumberInput,
        StockObject,
        StockObjectContainerLevels,
        StockObjectContainerLevelsBinding,
        StockObjectContainerLevelsInput,
        StockObjectInput,
    } from '@sage/wh-stock-data-api';
    import type { Package as SageWhStructure$Package } from '@sage/wh-structure-api';
    import type { Package as SageWhSystem$Package, Site } from '@sage/wh-system-api';
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type { Package as SageXtremX3SystemUtils$Package, SysUser } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        BinaryStream,
        ClientCollection,
        ClientNode,
        ClientNodeInput,
        GetDefaultsOperation,
        QueryOperation,
        ReadOperation,
        VitalClientNode,
        VitalClientNodeInput,
        decimal,
        integer,
    } from '@sage/xtrem-client';
    export interface AdjustmentMovementFinalsAndInitialsValues extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        consumptionUnitQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        container: ProductContainer;
        numberOfContainer: string;
        stockStatus: StockNature;
        originSource: Origin;
        reservationNumber: string;
        supportNumber: string;
        lotNumber: string;
        receiptDate: string;
        manufacturedDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        detentionDate: string;
        fifoDate: string;
    }
    export interface AdjustmentMovementFinalsAndInitialsValuesInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        consumptionUnitQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousQuantity?: decimal | string;
        container?: string;
        numberOfContainer?: decimal | string;
        stockStatus?: string;
        originSource?: string;
        reservationNumber?: string;
        supportNumber?: string;
        lotNumber?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        detentionDate?: string;
        fifoDate?: string;
    }
    export interface AdjustmentMovementFinalsAndInitialsValuesBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        consumptionUnitQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        container: ProductContainer;
        numberOfContainer: string;
        stockStatus: StockNature;
        originSource: Origin;
        reservationNumber: string;
        supportNumber: string;
        lotNumber: string;
        receiptDate: string;
        manufacturedDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        detentionDate: string;
        fifoDate: string;
    }
    export interface AdjustmentMovementFinalsAndInitialsValues$Lookups {
        homogeneousContainer: QueryOperation<ProductContainer>;
        container: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        originSource: QueryOperation<Origin>;
    }
    export interface AdjustmentMovementFinalsAndInitialsValues$Operations {
        query: QueryOperation<AdjustmentMovementFinalsAndInitialsValues>;
        read: ReadOperation<AdjustmentMovementFinalsAndInitialsValues>;
        aggregate: {
            read: AggregateReadOperation<AdjustmentMovementFinalsAndInitialsValues>;
            query: AggregateQueryOperation<AdjustmentMovementFinalsAndInitialsValues>;
        };
        lookups(
            dataOrId: string | { data: AdjustmentMovementFinalsAndInitialsValuesInput },
        ): AdjustmentMovementFinalsAndInitialsValues$Lookups;
        getDefaults: GetDefaultsOperation<AdjustmentMovementFinalsAndInitialsValues>;
    }
    export interface AdjustmentMovement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        date: string;
        time: string;
        movement: MovementCode;
        movementType: AdjustmentType;
        product: Product;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        stockObjectLinkNumber: string;
        adjustmentQuantity: string;
        adjustmentContainer: ProductContainer;
        adjustmentConsumptionUnitQuantity: string;
        level: ContainerLevel;
        isKeyInSerialNumber: boolean;
        stockCount: StockCount;
        counting: Counting;
        countingLine: CountLine;
        assemblyDeclaration: KitDeclaration;
        transfer: TransferMovement;
        movementTransfer: TransferMovement;
        adjustmentComment: string;
        finalsAndInitialsValues: ClientCollection<AdjustmentMovementFinalsAndInitialsValues>;
    }
    export interface AdjustmentMovementInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        date?: string;
        time?: string;
        movement?: string;
        movementType?: AdjustmentType;
        product?: string;
        store?: string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        containerNumber?: string;
        stockObjectLinkNumber?: string;
        adjustmentQuantity?: decimal | string;
        adjustmentContainer?: string;
        adjustmentConsumptionUnitQuantity?: decimal | string;
        level?: ContainerLevel;
        isKeyInSerialNumber?: boolean | string;
        stockCount?: string;
        counting?: integer | string;
        countingLine?: integer | string;
        assemblyDeclaration?: string;
        transfer?: string;
        movementTransfer?: string;
        adjustmentComment?: string;
        finalsAndInitialsValues?: Partial<AdjustmentMovementFinalsAndInitialsValuesInput>[];
    }
    export interface AdjustmentMovementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        date: string;
        time: string;
        movement: MovementCode;
        movementType: AdjustmentType;
        product: Product;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        containerNumber: string;
        stockObjectLinkNumber: string;
        adjustmentQuantity: string;
        adjustmentContainer: ProductContainer;
        adjustmentConsumptionUnitQuantity: string;
        level: ContainerLevel;
        isKeyInSerialNumber: boolean;
        stockCount: StockCount;
        counting: Counting;
        countingLine: CountLine;
        assemblyDeclaration: KitDeclaration;
        transfer: TransferMovement;
        movementTransfer: TransferMovement;
        adjustmentComment: string;
        finalsAndInitialsValues: ClientCollection<AdjustmentMovementFinalsAndInitialsValuesBinding>;
    }
    export interface AdjustmentMovement$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        movement: QueryOperation<MovementCode>;
        product: QueryOperation<Product>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        adjustmentContainer: QueryOperation<ProductContainer>;
        stockCount: QueryOperation<StockCount>;
        counting: QueryOperation<Counting>;
        countingLine: QueryOperation<CountLine>;
        assemblyDeclaration: QueryOperation<KitDeclaration>;
        transfer: QueryOperation<TransferMovement>;
        movementTransfer: QueryOperation<TransferMovement>;
    }
    export interface AdjustmentMovement$Operations {
        query: QueryOperation<AdjustmentMovement>;
        read: ReadOperation<AdjustmentMovement>;
        aggregate: {
            read: AggregateReadOperation<AdjustmentMovement>;
            query: AggregateQueryOperation<AdjustmentMovement>;
        };
        lookups(dataOrId: string | { data: AdjustmentMovementInput }): AdjustmentMovement$Lookups;
        getDefaults: GetDefaultsOperation<AdjustmentMovement>;
    }
    export interface AssemblingMovementContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface AssemblingMovementContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface AssemblingMovementContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface AssemblingMovementContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface AssemblingMovementContainerLevels$Operations {
        query: QueryOperation<AssemblingMovementContainerLevels>;
        read: ReadOperation<AssemblingMovementContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<AssemblingMovementContainerLevels>;
            query: AggregateQueryOperation<AssemblingMovementContainerLevels>;
        };
        lookups(
            dataOrId: string | { data: AssemblingMovementContainerLevelsInput },
        ): AssemblingMovementContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<AssemblingMovementContainerLevels>;
    }
    export interface AssemblingMovement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        assemblyOrder: AssemblingOrder;
        assemblyOrderLineNumber: integer;
        assemblyWave: AssemblingWave;
        lineType: DoLineType;
        product: Product;
        numberOfContainer: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        consumptionUnitQuantity: string;
        numberOfKits: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: AssemblyMovementStatus;
        originSource: Origin;
        receiptDate: string;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        replenishment: TransferMovement;
        transfer: TransferMovement;
        adjustment: AdjustmentMovement;
        kitDeclaration: KitDeclaration;
        isKitTransferAuthorized: boolean;
        flowNumber: integer;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        originQuantity: string;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        containerLevels: ClientCollection<AssemblingMovementContainerLevels>;
    }
    export interface AssemblingMovementInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        assemblyOrder?: string;
        assemblyOrderLineNumber?: integer | string;
        assemblyWave?: string;
        lineType?: DoLineType;
        product?: string;
        numberOfContainer?: decimal | string;
        container?: string;
        homogeneousContainerCoefficient?: decimal | string;
        consumptionUnitQuantity?: decimal | string;
        numberOfKits?: decimal | string;
        movementCode?: string;
        lotNumber?: string;
        stockStatus?: string;
        reservationNumber?: string;
        supportNumber?: string;
        status?: AssemblyMovementStatus;
        originSource?: string;
        receiptDate?: string;
        fifoDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        store?: string;
        location?: string;
        locationType?: LocationType;
        stockObject?: string;
        replenishment?: string;
        transfer?: string;
        adjustment?: string;
        kitDeclaration?: string;
        isKitTransferAuthorized?: boolean | string;
        flowNumber?: integer | string;
        containerNumber?: string;
        homogeneousContainer?: string;
        homogeneousQuantity?: decimal | string;
        originContainer?: string;
        originQuantity?: decimal | string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        containerLevels?: Partial<AssemblingMovementContainerLevelsInput>[];
    }
    export interface AssemblingMovementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        assemblyOrder: AssemblingOrder;
        assemblyOrderLineNumber: integer;
        assemblyWave: AssemblingWave;
        lineType: DoLineType;
        product: Product;
        numberOfContainer: string;
        container: ProductContainer;
        homogeneousContainerCoefficient: string;
        consumptionUnitQuantity: string;
        numberOfKits: string;
        movementCode: MovementCode;
        lotNumber: string;
        stockStatus: StockNature;
        reservationNumber: string;
        supportNumber: string;
        status: AssemblyMovementStatus;
        originSource: Origin;
        receiptDate: string;
        fifoDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        store: Store;
        location: Location;
        locationType: LocationType;
        stockObject: StockObject;
        replenishment: TransferMovement;
        transfer: TransferMovement;
        adjustment: AdjustmentMovement;
        kitDeclaration: KitDeclaration;
        isKitTransferAuthorized: boolean;
        flowNumber: integer;
        containerNumber: string;
        homogeneousContainer: ProductContainer;
        homogeneousQuantity: string;
        originContainer: ProductContainer;
        originQuantity: string;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        containerLevels: ClientCollection<AssemblingMovementContainerLevelsBinding>;
    }
    export interface AssemblingMovement$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        assemblyOrder: QueryOperation<AssemblingOrder>;
        assemblyWave: QueryOperation<AssemblingWave>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        movementCode: QueryOperation<MovementCode>;
        stockStatus: QueryOperation<StockNature>;
        originSource: QueryOperation<Origin>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        replenishment: QueryOperation<TransferMovement>;
        transfer: QueryOperation<TransferMovement>;
        adjustment: QueryOperation<AdjustmentMovement>;
        kitDeclaration: QueryOperation<KitDeclaration>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        originContainer: QueryOperation<ProductContainer>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface AssemblingMovement$Operations {
        query: QueryOperation<AssemblingMovement>;
        read: ReadOperation<AssemblingMovement>;
        aggregate: {
            read: AggregateReadOperation<AssemblingMovement>;
            query: AggregateQueryOperation<AssemblingMovement>;
        };
        lookups(dataOrId: string | { data: AssemblingMovementInput }): AssemblingMovement$Lookups;
        getDefaults: GetDefaultsOperation<AssemblingMovement>;
    }
    export interface AssemblingOrderLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        assemblyOrder: AssemblingOrder;
        lineNumber: integer;
        status: AssemblyOrderStatus;
        date: string;
        reference: string;
        stockStatus: StockNature;
        lotNumber: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainer: string;
        container: ProductContainer;
        totalQuantity: string;
        launchedQuantity: string;
        shortageQuantity: string;
        declaredQuantity: string;
        validatedQuantity: string;
        launchDate: string;
        launchTime: string;
        endProcessingDate: string;
        endProcessingTime: string;
        kitDeclaration: KitDeclaration;
        numberOfKitQuantity: string;
        movementCode: MovementCode;
        comments: string;
        notes: string;
        assemblyWave: AssemblingWave;
        flowNumber: integer;
    }
    export interface AssemblingOrderLineInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        assemblyOrder?: string;
        lineNumber?: integer | string;
        status?: AssemblyOrderStatus;
        date?: string;
        reference?: string;
        stockStatus?: string;
        lotNumber?: string;
        lineType?: DoLineType;
        product?: string;
        numberOfContainer?: decimal | string;
        container?: string;
        totalQuantity?: decimal | string;
        launchedQuantity?: decimal | string;
        shortageQuantity?: decimal | string;
        declaredQuantity?: decimal | string;
        validatedQuantity?: decimal | string;
        launchDate?: string;
        launchTime?: string;
        endProcessingDate?: string;
        endProcessingTime?: string;
        kitDeclaration?: string;
        numberOfKitQuantity?: decimal | string;
        movementCode?: string;
        comments?: string;
        notes?: string;
        assemblyWave?: string;
        flowNumber?: integer | string;
    }
    export interface AssemblingOrderLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        assemblyOrder: AssemblingOrder;
        lineNumber: integer;
        status: AssemblyOrderStatus;
        date: string;
        reference: string;
        stockStatus: StockNature;
        lotNumber: string;
        lineType: DoLineType;
        product: Product;
        numberOfContainer: string;
        container: ProductContainer;
        totalQuantity: string;
        launchedQuantity: string;
        shortageQuantity: string;
        declaredQuantity: string;
        validatedQuantity: string;
        launchDate: string;
        launchTime: string;
        endProcessingDate: string;
        endProcessingTime: string;
        kitDeclaration: KitDeclaration;
        numberOfKitQuantity: string;
        movementCode: MovementCode;
        comments: string;
        notes: string;
        assemblyWave: AssemblingWave;
        flowNumber: integer;
    }
    export interface AssemblingOrderLine$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        assemblyOrder: QueryOperation<AssemblingOrder>;
        stockStatus: QueryOperation<StockNature>;
        product: QueryOperation<Product>;
        container: QueryOperation<ProductContainer>;
        kitDeclaration: QueryOperation<KitDeclaration>;
        movementCode: QueryOperation<MovementCode>;
        assemblyWave: QueryOperation<AssemblingWave>;
    }
    export interface AssemblingOrderLine$Operations {
        query: QueryOperation<AssemblingOrderLine>;
        read: ReadOperation<AssemblingOrderLine>;
        aggregate: {
            read: AggregateReadOperation<AssemblingOrderLine>;
            query: AggregateQueryOperation<AssemblingOrderLine>;
        };
        lookups(dataOrId: string | { data: AssemblingOrderLineInput }): AssemblingOrderLine$Lookups;
        getDefaults: GetDefaultsOperation<AssemblingOrderLine>;
    }
    export interface AssemblingOrder extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        reference: string;
        type: Type;
        isUrgent: boolean;
        servicePriority: ServicePriority;
        status: AssemblyOrderStatus;
        date: string;
        workOrderNumber: string;
        workOrderDate: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        plannedEndDate: string;
        plannedEndTime: string;
        transmittedByL3: TransmissionL3;
        endProcessingDate: string;
        endProcessingTime: string;
        movementCode: MovementCode;
        assemblyWave: AssemblingWave;
        launchDate: string;
        launchTime: string;
        lines: ClientCollection<AssemblingOrderLine>;
    }
    export interface AssemblingOrderInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        reference?: string;
        type?: Type;
        isUrgent?: boolean | string;
        servicePriority?: ServicePriority;
        status?: AssemblyOrderStatus;
        date?: string;
        workOrderNumber?: string;
        workOrderDate?: string;
        plannedLaunchDate?: string;
        plannedLaunchTime?: string;
        plannedEndDate?: string;
        plannedEndTime?: string;
        transmittedByL3?: TransmissionL3;
        endProcessingDate?: string;
        endProcessingTime?: string;
        movementCode?: string;
        assemblyWave?: string;
        launchDate?: string;
        launchTime?: string;
        lines?: Partial<AssemblingOrderLineInput>[];
    }
    export interface AssemblingOrderBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        reference: string;
        type: Type;
        isUrgent: boolean;
        servicePriority: ServicePriority;
        status: AssemblyOrderStatus;
        date: string;
        workOrderNumber: string;
        workOrderDate: string;
        plannedLaunchDate: string;
        plannedLaunchTime: string;
        plannedEndDate: string;
        plannedEndTime: string;
        transmittedByL3: TransmissionL3;
        endProcessingDate: string;
        endProcessingTime: string;
        movementCode: MovementCode;
        assemblyWave: AssemblingWave;
        launchDate: string;
        launchTime: string;
        lines: ClientCollection<AssemblingOrderLine>;
    }
    export interface AssemblingOrder$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        movementCode: QueryOperation<MovementCode>;
        assemblyWave: QueryOperation<AssemblingWave>;
    }
    export interface AssemblingOrder$Operations {
        query: QueryOperation<AssemblingOrder>;
        read: ReadOperation<AssemblingOrder>;
        aggregate: {
            read: AggregateReadOperation<AssemblingOrder>;
            query: AggregateQueryOperation<AssemblingOrder>;
        };
        lookups(dataOrId: string | { data: AssemblingOrderInput }): AssemblingOrder$Lookups;
        getDefaults: GetDefaultsOperation<AssemblingOrder>;
    }
    export interface AssemblingWave extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        type: Type;
        launchDate: string;
        launchTime: string;
        numberOfAssemblyOrders: integer;
        numberOfAssemblyOrderLines: integer;
        numberOfReserveMovements: integer;
        numberOfPickingMovements: integer;
        numberOfIncompleteLines: integer;
        numberOfReplenishmentMovements: integer;
        numberOfTransferOrders: integer;
        status: WaveStatus;
        volume: string;
        weight: string;
        numberOfTransferMovements: integer;
        store: Store;
        location: Location;
        isAvailableStock: boolean;
        isPickingStock: boolean;
        isTransferIncomplete: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
    }
    export interface AssemblingWaveInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        type?: Type;
        launchDate?: string;
        launchTime?: string;
        numberOfAssemblyOrders?: integer | string;
        numberOfAssemblyOrderLines?: integer | string;
        numberOfReserveMovements?: integer | string;
        numberOfPickingMovements?: integer | string;
        numberOfIncompleteLines?: integer | string;
        numberOfReplenishmentMovements?: integer | string;
        numberOfTransferOrders?: integer | string;
        status?: WaveStatus;
        volume?: decimal | string;
        weight?: decimal | string;
        numberOfTransferMovements?: integer | string;
        store?: string;
        location?: string;
        isAvailableStock?: boolean | string;
        isPickingStock?: boolean | string;
        isTransferIncomplete?: boolean | string;
        isMissionToBlock?: boolean | string;
        missionPriority?: integer | string;
    }
    export interface AssemblingWaveBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        type: Type;
        launchDate: string;
        launchTime: string;
        numberOfAssemblyOrders: integer;
        numberOfAssemblyOrderLines: integer;
        numberOfReserveMovements: integer;
        numberOfPickingMovements: integer;
        numberOfIncompleteLines: integer;
        numberOfReplenishmentMovements: integer;
        numberOfTransferOrders: integer;
        status: WaveStatus;
        volume: string;
        weight: string;
        numberOfTransferMovements: integer;
        store: Store;
        location: Location;
        isAvailableStock: boolean;
        isPickingStock: boolean;
        isTransferIncomplete: boolean;
        isMissionToBlock: boolean;
        missionPriority: integer;
    }
    export interface AssemblingWave$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
    }
    export interface AssemblingWave$Operations {
        query: QueryOperation<AssemblingWave>;
        read: ReadOperation<AssemblingWave>;
        aggregate: {
            read: AggregateReadOperation<AssemblingWave>;
            query: AggregateQueryOperation<AssemblingWave>;
        };
        lookups(dataOrId: string | { data: AssemblingWaveInput }): AssemblingWave$Lookups;
        getDefaults: GetDefaultsOperation<AssemblingWave>;
    }
    export interface CountLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        counting: Counting;
        line: integer;
        isKeyInSerialNumber: boolean;
        isInput: boolean;
        sort: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        numberOfContainer: string;
        container: ProductContainer;
        consumptionUnitQuantity: string;
        stockStatus: StockNature;
        reservationNumber: string;
        lotNumber: string;
        supportNumber: string;
        originSource: Origin;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        rowLevel: string;
        travelSequence: string;
        inventoryDiscrepancy: InventoryDiscrepancy;
    }
    export interface CountLineInput extends ClientNodeInput {
        site?: string;
        stockCount?: string;
        counting?: integer | string;
        line?: integer | string;
        isKeyInSerialNumber?: boolean | string;
        isInput?: boolean | string;
        sort?: string;
        depositor?: string;
        product?: string;
        store?: string;
        location?: string;
        numberOfContainer?: decimal | string;
        container?: string;
        consumptionUnitQuantity?: decimal | string;
        stockStatus?: string;
        reservationNumber?: string;
        lotNumber?: string;
        supportNumber?: string;
        originSource?: string;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        rowLevel?: string;
        travelSequence?: string;
        inventoryDiscrepancy?: InventoryDiscrepancy;
    }
    export interface CountLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        counting: Counting;
        line: integer;
        isKeyInSerialNumber: boolean;
        isInput: boolean;
        sort: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        numberOfContainer: string;
        container: ProductContainer;
        consumptionUnitQuantity: string;
        stockStatus: StockNature;
        reservationNumber: string;
        lotNumber: string;
        supportNumber: string;
        originSource: Origin;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        rowLevel: string;
        travelSequence: string;
        inventoryDiscrepancy: InventoryDiscrepancy;
    }
    export interface CountLine$Lookups {
        site: QueryOperation<Site>;
        stockCount: QueryOperation<StockCount>;
        counting: QueryOperation<Counting>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        container: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        originSource: QueryOperation<Origin>;
    }
    export interface CountLine$Operations {
        query: QueryOperation<CountLine>;
        read: ReadOperation<CountLine>;
        aggregate: {
            read: AggregateReadOperation<CountLine>;
            query: AggregateQueryOperation<CountLine>;
        };
        lookups(dataOrId: string | { data: CountLineInput }): CountLine$Lookups;
        getDefaults: GetDefaultsOperation<CountLine>;
    }
    export interface Counting extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        code: integer;
        reference: string;
        status: InventoryStatus;
        countingType: CountingType;
        isProductWithoutStock: boolean;
        store: Store;
        aisle: string;
        row: string;
        isPicking: boolean;
        isReserve: boolean;
        referenceCount1: Counting;
        referenceCount2: Counting;
        lineInError: InventoryDiscrepancy;
        comments: string;
        date: string;
        closingDate: string;
        numberOfLines: integer;
    }
    export interface CountingInput extends ClientNodeInput {
        site?: string;
        stockCount?: string;
        code?: integer | string;
        reference?: string;
        status?: InventoryStatus;
        countingType?: CountingType;
        isProductWithoutStock?: boolean | string;
        store?: string;
        aisle?: string;
        row?: string;
        isPicking?: boolean | string;
        isReserve?: boolean | string;
        referenceCount1?: integer | string;
        referenceCount2?: integer | string;
        lineInError?: InventoryDiscrepancy;
        comments?: string;
        date?: string;
        closingDate?: string;
        numberOfLines?: integer | string;
    }
    export interface CountingBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        code: integer;
        reference: string;
        status: InventoryStatus;
        countingType: CountingType;
        isProductWithoutStock: boolean;
        store: Store;
        aisle: string;
        row: string;
        isPicking: boolean;
        isReserve: boolean;
        referenceCount1: Counting;
        referenceCount2: Counting;
        lineInError: InventoryDiscrepancy;
        comments: string;
        date: string;
        closingDate: string;
        numberOfLines: integer;
    }
    export interface Counting$Lookups {
        site: QueryOperation<Site>;
        stockCount: QueryOperation<StockCount>;
        store: QueryOperation<Store>;
        referenceCount1: QueryOperation<Counting>;
        referenceCount2: QueryOperation<Counting>;
    }
    export interface Counting$Operations {
        query: QueryOperation<Counting>;
        read: ReadOperation<Counting>;
        aggregate: {
            read: AggregateReadOperation<Counting>;
            query: AggregateQueryOperation<Counting>;
        };
        lookups(dataOrId: string | { data: CountingInput }): Counting$Lookups;
        getDefaults: GetDefaultsOperation<Counting>;
    }
    export interface KitDeclaration extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        assemblyOrder: AssemblingOrder;
        assemblyOrderLine: AssemblingOrderLine;
        kit: Product;
        quantity: string;
        assemblyWave: AssemblingWave;
        status: AssemblyMovementStatus;
        type: Type;
        postingDate: string;
        validatingUser: string;
        validatingOperator: Operand;
    }
    export interface KitDeclarationInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        code?: string;
        assemblyOrder?: string;
        assemblyOrderLine?: integer | string;
        kit?: string;
        quantity?: decimal | string;
        assemblyWave?: string;
        status?: AssemblyMovementStatus;
        type?: Type;
        postingDate?: string;
        validatingUser?: string;
        validatingOperator?: string;
    }
    export interface KitDeclarationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        assemblyOrder: AssemblingOrder;
        assemblyOrderLine: AssemblingOrderLine;
        kit: Product;
        quantity: string;
        assemblyWave: AssemblingWave;
        status: AssemblyMovementStatus;
        type: Type;
        postingDate: string;
        validatingUser: string;
        validatingOperator: Operand;
    }
    export interface KitDeclaration$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        assemblyOrder: QueryOperation<AssemblingOrder>;
        assemblyOrderLine: QueryOperation<AssemblingOrderLine>;
        kit: QueryOperation<Product>;
        assemblyWave: QueryOperation<AssemblingWave>;
        validatingOperator: QueryOperation<Operand>;
    }
    export interface KitDeclaration$Operations {
        query: QueryOperation<KitDeclaration>;
        read: ReadOperation<KitDeclaration>;
        aggregate: {
            read: AggregateReadOperation<KitDeclaration>;
            query: AggregateQueryOperation<KitDeclaration>;
        };
        lookups(dataOrId: string | { data: KitDeclarationInput }): KitDeclaration$Lookups;
        getDefaults: GetDefaultsOperation<KitDeclaration>;
    }
    export interface SerialNumberCountingLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        counting: Counting;
        lineNumber: integer;
        serialNumber: string;
        double: integer;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        serialGroup: string;
        parentGroup: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        isNonExistentSerialNumber: boolean;
    }
    export interface SerialNumberCountingLineInput extends ClientNodeInput {
        site?: string;
        stockCount?: string;
        counting?: integer | string;
        lineNumber?: integer | string;
        serialNumber?: string;
        double?: integer | string;
        depositor?: string;
        product?: string;
        store?: string;
        location?: string;
        serialGroup?: string;
        parentGroup?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
        isNonExistentSerialNumber?: boolean | string;
    }
    export interface SerialNumberCountingLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        counting: Counting;
        lineNumber: integer;
        serialNumber: string;
        double: integer;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        serialGroup: string;
        parentGroup: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        isNonExistentSerialNumber: boolean;
    }
    export interface SerialNumberCountingLine$Lookups {
        site: QueryOperation<Site>;
        stockCount: QueryOperation<StockCount>;
        counting: QueryOperation<Counting>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
    }
    export interface SerialNumberCountingLine$Operations {
        query: QueryOperation<SerialNumberCountingLine>;
        read: ReadOperation<SerialNumberCountingLine>;
        aggregate: {
            read: AggregateReadOperation<SerialNumberCountingLine>;
            query: AggregateQueryOperation<SerialNumberCountingLine>;
        };
        lookups(dataOrId: string | { data: SerialNumberCountingLineInput }): SerialNumberCountingLine$Lookups;
        getDefaults: GetDefaultsOperation<SerialNumberCountingLine>;
    }
    export interface SimplifiedStockCountLine extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        simplifiedStockCount: SimplifiedStockCount;
        line: integer;
        status: SimplifiedStockCountStatus;
        depositor: Depositor;
        product: Product;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        enteredQuantity: string;
        pendingInputQuantity: string;
        pendingOutputQuantity: string;
        expectedQuantity: string;
    }
    export interface SimplifiedStockCountLineInput extends ClientNodeInput {
        site?: string;
        simplifiedStockCount?: string;
        line?: integer | string;
        status?: SimplifiedStockCountStatus;
        depositor?: string;
        product?: string;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        enteredQuantity?: decimal | string;
        pendingInputQuantity?: decimal | string;
        pendingOutputQuantity?: decimal | string;
        expectedQuantity?: decimal | string;
    }
    export interface SimplifiedStockCountLineBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        simplifiedStockCount: SimplifiedStockCount;
        line: integer;
        status: SimplifiedStockCountStatus;
        depositor: Depositor;
        product: Product;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        enteredQuantity: string;
        pendingInputQuantity: string;
        pendingOutputQuantity: string;
        expectedQuantity: string;
    }
    export interface SimplifiedStockCountLine$Lookups {
        site: QueryOperation<Site>;
        simplifiedStockCount: QueryOperation<SimplifiedStockCount>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        homogeneousContainer: QueryOperation<ProductContainer>;
    }
    export interface SimplifiedStockCountLine$Operations {
        query: QueryOperation<SimplifiedStockCountLine>;
        read: ReadOperation<SimplifiedStockCountLine>;
        aggregate: {
            read: AggregateReadOperation<SimplifiedStockCountLine>;
            query: AggregateQueryOperation<SimplifiedStockCountLine>;
        };
        lookups(dataOrId: string | { data: SimplifiedStockCountLineInput }): SimplifiedStockCountLine$Lookups;
        getDefaults: GetDefaultsOperation<SimplifiedStockCountLine>;
    }
    export interface SimplifiedStockCount extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        status: SimplifiedStockCountStatus;
        store: Store;
        location: Location;
        closingDate: string;
    }
    export interface SimplifiedStockCountInput extends ClientNodeInput {
        site?: string;
        code?: string;
        reference?: string;
        status?: SimplifiedStockCountStatus;
        store?: string;
        location?: string;
        closingDate?: string;
    }
    export interface SimplifiedStockCountBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        status: SimplifiedStockCountStatus;
        store: Store;
        location: Location;
        closingDate: string;
    }
    export interface SimplifiedStockCount$Lookups {
        site: QueryOperation<Site>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
    }
    export interface SimplifiedStockCount$Operations {
        query: QueryOperation<SimplifiedStockCount>;
        read: ReadOperation<SimplifiedStockCount>;
        aggregate: {
            read: AggregateReadOperation<SimplifiedStockCount>;
            query: AggregateQueryOperation<SimplifiedStockCount>;
        };
        lookups(dataOrId: string | { data: SimplifiedStockCountInput }): SimplifiedStockCount$Lookups;
        getDefaults: GetDefaultsOperation<SimplifiedStockCount>;
    }
    export interface StockCountCampaign extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        startDate: string;
        endDate: string;
        status: InventoryStatus;
        closingDate: string;
        numberOfStockCountsInProgress: integer;
        numberOfStockCountsClosed: integer;
    }
    export interface StockCountCampaignInput extends ClientNodeInput {
        site?: string;
        code?: string;
        reference?: string;
        startDate?: string;
        endDate?: string;
        status?: InventoryStatus;
        closingDate?: string;
        numberOfStockCountsInProgress?: integer | string;
        numberOfStockCountsClosed?: integer | string;
    }
    export interface StockCountCampaignBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        startDate: string;
        endDate: string;
        status: InventoryStatus;
        closingDate: string;
        numberOfStockCountsInProgress: integer;
        numberOfStockCountsClosed: integer;
    }
    export interface StockCountCampaign$Lookups {
        site: QueryOperation<Site>;
    }
    export interface StockCountCampaign$Operations {
        query: QueryOperation<StockCountCampaign>;
        read: ReadOperation<StockCountCampaign>;
        aggregate: {
            read: AggregateReadOperation<StockCountCampaign>;
            query: AggregateQueryOperation<StockCountCampaign>;
        };
        lookups(dataOrId: string | { data: StockCountCampaignInput }): StockCountCampaign$Lookups;
        getDefaults: GetDefaultsOperation<StockCountCampaign>;
    }
    export interface StockCountLinesByLocation extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        selection: integer;
        store: Store;
        location: Location;
        status: InventoryLineType;
        numberOfProducts: integer;
    }
    export interface StockCountLinesByLocationInput extends ClientNodeInput {
        site?: string;
        stockCount?: string;
        selection?: integer | string;
        store?: string;
        location?: string;
        status?: InventoryLineType;
        numberOfProducts?: integer | string;
    }
    export interface StockCountLinesByLocationBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        selection: integer;
        store: Store;
        location: Location;
        status: InventoryLineType;
        numberOfProducts: integer;
    }
    export interface StockCountLinesByLocation$Lookups {
        site: QueryOperation<Site>;
        stockCount: QueryOperation<StockCount>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
    }
    export interface StockCountLinesByLocation$Operations {
        query: QueryOperation<StockCountLinesByLocation>;
        read: ReadOperation<StockCountLinesByLocation>;
        aggregate: {
            read: AggregateReadOperation<StockCountLinesByLocation>;
            query: AggregateQueryOperation<StockCountLinesByLocation>;
        };
        lookups(dataOrId: string | { data: StockCountLinesByLocationInput }): StockCountLinesByLocation$Lookups;
        getDefaults: GetDefaultsOperation<StockCountLinesByLocation>;
    }
    export interface StockCountLinesByProduct extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        selection: integer;
        depositor: Depositor;
        product: Product;
        status: InventoryLineType;
        numberOfLocations: integer;
    }
    export interface StockCountLinesByProductInput extends ClientNodeInput {
        site?: string;
        stockCount?: string;
        selection?: integer | string;
        depositor?: string;
        product?: string;
        status?: InventoryLineType;
        numberOfLocations?: integer | string;
    }
    export interface StockCountLinesByProductBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        stockCount: StockCount;
        selection: integer;
        depositor: Depositor;
        product: Product;
        status: InventoryLineType;
        numberOfLocations: integer;
    }
    export interface StockCountLinesByProduct$Lookups {
        site: QueryOperation<Site>;
        stockCount: QueryOperation<StockCount>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
    }
    export interface StockCountLinesByProduct$Operations {
        query: QueryOperation<StockCountLinesByProduct>;
        read: ReadOperation<StockCountLinesByProduct>;
        aggregate: {
            read: AggregateReadOperation<StockCountLinesByProduct>;
            query: AggregateQueryOperation<StockCountLinesByProduct>;
        };
        lookups(dataOrId: string | { data: StockCountLinesByProductInput }): StockCountLinesByProduct$Lookups;
        getDefaults: GetDefaultsOperation<StockCountLinesByProduct>;
    }
    export interface StockCount extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        status: InventoryStatus;
        isCreatedByOneCampaign: boolean;
        stockCountCampaign: StockCountCampaign;
        closingDate: string;
        stockCountType: InventoryType;
        isKeyInSerialNumber: boolean;
        isPendingStockCount: boolean;
        maximumContainerLevel: ContainerLevel;
        comments: string;
        logFileNumber: string;
        numberOfCounting: integer;
        stockCountCreationOrigin: StockCountCreationOrigin;
    }
    export interface StockCountInput extends ClientNodeInput {
        site?: string;
        code?: string;
        reference?: string;
        status?: InventoryStatus;
        isCreatedByOneCampaign?: boolean | string;
        stockCountCampaign?: string;
        closingDate?: string;
        stockCountType?: InventoryType;
        isKeyInSerialNumber?: boolean | string;
        isPendingStockCount?: boolean | string;
        maximumContainerLevel?: ContainerLevel;
        comments?: string;
        logFileNumber?: string;
        numberOfCounting?: integer | string;
        stockCountCreationOrigin?: StockCountCreationOrigin;
    }
    export interface StockCountBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        reference: string;
        status: InventoryStatus;
        isCreatedByOneCampaign: boolean;
        stockCountCampaign: StockCountCampaign;
        closingDate: string;
        stockCountType: InventoryType;
        isKeyInSerialNumber: boolean;
        isPendingStockCount: boolean;
        maximumContainerLevel: ContainerLevel;
        comments: string;
        logFileNumber: string;
        numberOfCounting: integer;
        stockCountCreationOrigin: StockCountCreationOrigin;
    }
    export interface StockCount$Lookups {
        site: QueryOperation<Site>;
        stockCountCampaign: QueryOperation<StockCountCampaign>;
    }
    export interface StockCount$Operations {
        query: QueryOperation<StockCount>;
        read: ReadOperation<StockCount>;
        aggregate: {
            read: AggregateReadOperation<StockCount>;
            query: AggregateQueryOperation<StockCount>;
        };
        lookups(dataOrId: string | { data: StockCountInput }): StockCount$Lookups;
        getDefaults: GetDefaultsOperation<StockCount>;
    }
    export interface StockImage extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        stockStatus: StockNature;
        lotNumber: string;
        quantityInStock: string;
        quantityInPendingOutput: string;
        quantityInPendingInput: string;
        quantityReceivedButNotAddressed: string;
        quantityPreparedButNotShipped: string;
        quantityBlocked: string;
        quantityInReserve: string;
        quantityBlockedInPendingInput: string;
        quantityBlockedInPendingOutput: string;
        quantityReservedPendingInput: string;
        quantityReservedPendingOutput: string;
        quantityInBalanceForPreparation: string;
        quantityReserveToBePrepared: string;
        quantityExpected: string;
        quantityInPendingAssembly: string;
        stockUnit: UnitOfMeasure;
    }
    export interface StockImageInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        product?: string;
        stockStatus?: string;
        lotNumber?: string;
        quantityInStock?: decimal | string;
        quantityInPendingOutput?: decimal | string;
        quantityInPendingInput?: decimal | string;
        quantityReceivedButNotAddressed?: decimal | string;
        quantityPreparedButNotShipped?: decimal | string;
        quantityBlocked?: decimal | string;
        quantityInReserve?: decimal | string;
        quantityBlockedInPendingInput?: decimal | string;
        quantityBlockedInPendingOutput?: decimal | string;
        quantityReservedPendingInput?: decimal | string;
        quantityReservedPendingOutput?: decimal | string;
        quantityInBalanceForPreparation?: decimal | string;
        quantityReserveToBePrepared?: decimal | string;
        quantityExpected?: decimal | string;
        quantityInPendingAssembly?: decimal | string;
        stockUnit?: string;
    }
    export interface StockImageBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        stockStatus: StockNature;
        lotNumber: string;
        quantityInStock: string;
        quantityInPendingOutput: string;
        quantityInPendingInput: string;
        quantityReceivedButNotAddressed: string;
        quantityPreparedButNotShipped: string;
        quantityBlocked: string;
        quantityInReserve: string;
        quantityBlockedInPendingInput: string;
        quantityBlockedInPendingOutput: string;
        quantityReservedPendingInput: string;
        quantityReservedPendingOutput: string;
        quantityInBalanceForPreparation: string;
        quantityReserveToBePrepared: string;
        quantityExpected: string;
        quantityInPendingAssembly: string;
        stockUnit: UnitOfMeasure;
    }
    export interface StockImage$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        product: QueryOperation<Product>;
        stockStatus: QueryOperation<StockNature>;
        stockUnit: QueryOperation<UnitOfMeasure>;
    }
    export interface StockImage$Operations {
        query: QueryOperation<StockImage>;
        read: ReadOperation<StockImage>;
        aggregate: {
            read: AggregateReadOperation<StockImage>;
            query: AggregateQueryOperation<StockImage>;
        };
        lookups(dataOrId: string | { data: StockImageInput }): StockImage$Lookups;
        getDefaults: GetDefaultsOperation<StockImage>;
    }
    export interface TransferMovementContainerLevels extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        transferNumber: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface TransferMovementContainerLevelsInput extends VitalClientNodeInput {
        denormalizedIndex?: integer | string;
        site?: string;
        depositor?: string;
        transferNumber?: string;
        code?: string;
        containerLevel?: string;
        quantityOfConsumptionUnitPerLevel?: decimal | string;
    }
    export interface TransferMovementContainerLevelsBinding extends VitalClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        denormalizedIndex: integer;
        site: string;
        depositor: string;
        transferNumber: string;
        code: string;
        containerLevel: ProductContainer;
        quantityOfConsumptionUnitPerLevel: string;
    }
    export interface TransferMovementContainerLevels$Lookups {
        containerLevel: QueryOperation<ProductContainer>;
    }
    export interface TransferMovementContainerLevels$Operations {
        query: QueryOperation<TransferMovementContainerLevels>;
        read: ReadOperation<TransferMovementContainerLevels>;
        aggregate: {
            read: AggregateReadOperation<TransferMovementContainerLevels>;
            query: AggregateQueryOperation<TransferMovementContainerLevels>;
        };
        lookups(
            dataOrId: string | { data: TransferMovementContainerLevelsInput },
        ): TransferMovementContainerLevels$Lookups;
        getDefaults: GetDefaultsOperation<TransferMovementContainerLevels>;
    }
    export interface TransferMovement extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        transferNumber: string;
        code: string;
        movementCode: MovementCode;
        assemblingWave: AssemblingWave;
        subWaveNumber: integer;
        adjustment: AdjustmentMovement;
        store: Store;
        location: Location;
        stockObject: StockObject;
        containerNumber: string;
        originStore: Store;
        originAddress: Location;
        locationType: LocationType;
        sourceProduct: Product;
        originStockObject: StockObject;
        originContainer: ProductContainer;
        originQuantity: string;
        originSource: Origin;
        numberOfContainer: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        level: ContainerLevel;
        status: ReplenishmentMovementType;
        movementType: MovementType;
        masterStockObject: StockObject;
        masterContainerNumber: string;
        masterProduct: Product;
        date: string;
        time: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        fifoDate: string;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        sortPreparationOrder: string;
        rowLevel: string;
        travelSequence: string;
        transferObject: StockObject;
        transferStore: Store;
        transferAddress: Location;
        position: integer;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        flowNumber: integer;
        pickingOperator: Operand;
        pickingUser: string;
        pickingDate: string;
        pickingTime: integer;
        groupingCode: string;
        depositObject: StockObject;
        depositStore: Store;
        depositLocation: Location;
        containerLevels: ClientCollection<TransferMovementContainerLevels>;
    }
    export interface TransferMovementInput extends ClientNodeInput {
        site?: string;
        depositor?: string;
        transferNumber?: string;
        code?: string;
        movementCode?: string;
        assemblingWave?: string;
        subWaveNumber?: integer | string;
        adjustment?: string;
        store?: string;
        location?: string;
        stockObject?: string;
        containerNumber?: string;
        originStore?: string;
        originAddress?: string;
        locationType?: LocationType;
        sourceProduct?: string;
        originStockObject?: string;
        originContainer?: string;
        originQuantity?: decimal | string;
        originSource?: string;
        numberOfContainer?: decimal | string;
        container?: string;
        numberOfConsumptionUnit?: decimal | string;
        level?: ContainerLevel;
        status?: ReplenishmentMovementType;
        movementType?: MovementType;
        masterStockObject?: string;
        masterContainerNumber?: string;
        masterProduct?: string;
        date?: string;
        time?: string;
        homogeneousQuantity?: decimal | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        shipByDate?: string;
        useByDate?: string;
        fifoDate?: string;
        lotNumber?: string;
        supportNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        sortPreparationOrder?: string;
        rowLevel?: string;
        travelSequence?: string;
        transferObject?: string;
        transferStore?: string;
        transferAddress?: string;
        position?: integer | string;
        validatingOperator?: string;
        validatingUser?: string;
        postingDate?: string;
        postingTime?: integer | string;
        flowNumber?: integer | string;
        pickingOperator?: string;
        pickingUser?: string;
        pickingDate?: string;
        pickingTime?: integer | string;
        groupingCode?: string;
        depositObject?: string;
        depositStore?: string;
        depositLocation?: string;
        containerLevels?: Partial<TransferMovementContainerLevelsInput>[];
    }
    export interface TransferMovementBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        transferNumber: string;
        code: string;
        movementCode: MovementCode;
        assemblingWave: AssemblingWave;
        subWaveNumber: integer;
        adjustment: AdjustmentMovement;
        store: Store;
        location: Location;
        stockObject: StockObject;
        containerNumber: string;
        originStore: Store;
        originAddress: Location;
        locationType: LocationType;
        sourceProduct: Product;
        originStockObject: StockObject;
        originContainer: ProductContainer;
        originQuantity: string;
        originSource: Origin;
        numberOfContainer: string;
        container: ProductContainer;
        numberOfConsumptionUnit: string;
        level: ContainerLevel;
        status: ReplenishmentMovementType;
        movementType: MovementType;
        masterStockObject: StockObject;
        masterContainerNumber: string;
        masterProduct: Product;
        date: string;
        time: string;
        homogeneousQuantity: string;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        shipByDate: string;
        useByDate: string;
        fifoDate: string;
        lotNumber: string;
        supportNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        sortPreparationOrder: string;
        rowLevel: string;
        travelSequence: string;
        transferObject: StockObject;
        transferStore: Store;
        transferAddress: Location;
        position: integer;
        validatingOperator: Operand;
        validatingUser: string;
        postingDate: string;
        postingTime: integer;
        flowNumber: integer;
        pickingOperator: Operand;
        pickingUser: string;
        pickingDate: string;
        pickingTime: integer;
        groupingCode: string;
        depositObject: StockObject;
        depositStore: Store;
        depositLocation: Location;
        containerLevels: ClientCollection<TransferMovementContainerLevelsBinding>;
    }
    export interface TransferMovement$Lookups {
        site: QueryOperation<Site>;
        depositor: QueryOperation<Depositor>;
        movementCode: QueryOperation<MovementCode>;
        assemblingWave: QueryOperation<AssemblingWave>;
        adjustment: QueryOperation<AdjustmentMovement>;
        store: QueryOperation<Store>;
        location: QueryOperation<Location>;
        stockObject: QueryOperation<StockObject>;
        originStore: QueryOperation<Store>;
        originAddress: QueryOperation<Location>;
        sourceProduct: QueryOperation<Product>;
        originStockObject: QueryOperation<StockObject>;
        originContainer: QueryOperation<ProductContainer>;
        originSource: QueryOperation<Origin>;
        container: QueryOperation<ProductContainer>;
        masterStockObject: QueryOperation<StockObject>;
        masterProduct: QueryOperation<Product>;
        homogeneousContainer: QueryOperation<ProductContainer>;
        stockStatus: QueryOperation<StockNature>;
        transferObject: QueryOperation<StockObject>;
        transferStore: QueryOperation<Store>;
        transferAddress: QueryOperation<Location>;
        validatingOperator: QueryOperation<Operand>;
        pickingOperator: QueryOperation<Operand>;
        depositObject: QueryOperation<StockObject>;
        depositStore: QueryOperation<Store>;
        depositLocation: QueryOperation<Location>;
    }
    export interface TransferMovement$Operations {
        query: QueryOperation<TransferMovement>;
        read: ReadOperation<TransferMovement>;
        aggregate: {
            read: AggregateReadOperation<TransferMovement>;
            query: AggregateQueryOperation<TransferMovement>;
        };
        lookups(dataOrId: string | { data: TransferMovementInput }): TransferMovement$Lookups;
        getDefaults: GetDefaultsOperation<TransferMovement>;
    }
    export interface LocationExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddresses>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
        stockCount: StockCount;
    }
    export interface LocationInputExtension {
        site?: string;
        store?: string;
        code?: string;
        storageType?: string;
        storage?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        dockType?: DockType;
        depositor?: string;
        lotNumber?: string;
        reservationNumber?: string;
        stockStatus?: string;
        numberOfConsumptionUnitPerContainer?: decimal | string;
        rotationClass?: string;
        assignmentClass?: string;
        prohibitedClass?: string;
        height?: decimal | string;
        width?: decimal | string;
        depth?: decimal | string;
        volume?: decimal | string;
        maxVolume?: decimal | string;
        maxWeightAuthorized?: decimal | string;
        maxMeters?: decimal | string;
        maximumLoad?: decimal | string;
        dockHeight?: decimal | string;
        storingTime?: decimal | string;
        unStockingTime?: decimal | string;
        presentContainerMaximumQuantity?: decimal | string;
        referenceContainerLevel?: integer | string;
        maximumQuantityInReferenceContainer?: decimal | string;
        quantityInStock?: decimal | string;
        lastStockCount?: string;
        lastReceipt?: string;
        firstArrival?: string;
        fifoDate?: string;
        quantityInPendingInput?: decimal | string;
        quantityInPendingOutput?: decimal | string;
        quantityInPendingReplenish?: decimal | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isAutoAddressing?: boolean | string;
        isKeyInControlCode?: boolean | string;
        controlCode?: string;
        reorderPoint?: decimal | string;
        replenishmentType?: LocationType;
        replenishmentLevel?: ContainerLevel;
        percentageOccupied?: integer | string;
        parity?: Parity;
        isTemporaryPicking?: boolean | string;
        isPickingPivot?: boolean | string;
        wavePivot?: string;
        pickingPriority?: integer | string;
        isUsed?: boolean | string;
        controlDimension?: ControlOfDimensions;
        isActive?: boolean | string;
        isDockLeveler?: boolean | string;
        completeObjectsAddressingThreshold?: decimal | string;
        splitAddresses?: Partial<LocationSplitAddressesInput>[];
        product?: string;
        container?: string;
        source?: string;
        referenceContainer?: string;
        presentContainer?: string;
        superiorContainer?: string;
        stockCount?: string;
    }
    export interface LocationBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        store: Store;
        code: string;
        storageType: string;
        storage: StorageType;
        storeType: StoreType;
        locationType: LocationType;
        dockType: DockType;
        depositor: Depositor;
        lotNumber: string;
        reservationNumber: string;
        stockStatus: StockNature;
        numberOfConsumptionUnitPerContainer: string;
        rotationClass: RotationClass;
        assignmentClass: AssignmentClass;
        prohibitedClass: AssignmentClass;
        height: string;
        width: string;
        depth: string;
        volume: string;
        maxVolume: string;
        maxWeightAuthorized: string;
        maxMeters: string;
        maximumLoad: string;
        dockHeight: string;
        storingTime: string;
        unStockingTime: string;
        presentContainerMaximumQuantity: string;
        referenceContainerLevel: integer;
        maximumQuantityInReferenceContainer: string;
        quantityInStock: string;
        lastStockCount: string;
        lastReceipt: string;
        firstArrival: string;
        fifoDate: string;
        quantityInPendingInput: string;
        quantityInPendingOutput: string;
        quantityInPendingReplenish: string;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isAutoAddressing: boolean;
        isKeyInControlCode: boolean;
        controlCode: string;
        reorderPoint: string;
        replenishmentType: LocationType;
        replenishmentLevel: ContainerLevel;
        percentageOccupied: integer;
        parity: Parity;
        isTemporaryPicking: boolean;
        isPickingPivot: boolean;
        wavePivot: string;
        pickingPriority: integer;
        isUsed: boolean;
        controlDimension: ControlOfDimensions;
        isActive: boolean;
        isDockLeveler: boolean;
        completeObjectsAddressingThreshold: string;
        displayCode: string;
        storeLocationCode: string;
        storeLocationKey: string;
        splitAddresses: ClientCollection<LocationSplitAddressesBinding>;
        product: Product;
        container: Container;
        source: Origin;
        referenceContainer: Container;
        presentContainer: Container;
        superiorContainer: ProductContainer;
        stockCount: StockCount;
    }
    export interface LocationExtension$Lookups {
        stockCount: QueryOperation<StockCount>;
    }
    export interface LocationExtension$Operations {
        lookups(dataOrId: string | { data: LocationInput }): LocationExtension$Lookups;
    }
    export interface ProductExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMatters>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptions>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMatters>;
        stockObjects: ClientCollection<StockObject>;
        stockCount: StockCount;
    }
    export interface ProductInputExtension {
        site?: string;
        depositor?: string;
        code?: string;
        otherCode?: string;
        localizedDescription?: string;
        localizedDescription2?: string;
        localizedShortDescription?: string;
        family?: string;
        subFamily?: string;
        group?: string;
        subGroup?: string;
        isKeyInSerialNumber?: boolean | string;
        stockCountClass?: string;
        numberStockCount?: integer | string;
        isBlockedInInput?: boolean | string;
        isBlockedInOutput?: boolean | string;
        isBlockedInInput2?: boolean | string;
        isBlockedInOutput2?: boolean | string;
        isKeyInLotNumber?: boolean | string;
        isSingleLot?: boolean | string;
        isCrossDocking?: boolean | string;
        isHazardousMaterials?: boolean | string;
        isKeyInControlCode?: boolean | string;
        fifoDateNature?: FifoDate;
        source?: string;
        inputMode?: string;
        outputMode?: string;
        autoTransferMode?: MovementType;
        detentionLength?: integer | string;
        detentionUnit?: UnitLength;
        useByDateLength?: integer | string;
        useByDateUnit?: UnitLength;
        sendByDateLength?: integer | string;
        sendByDateUnit?: UnitLength;
        sellByDateLength?: integer | string;
        sellByDateUnit?: UnitLength;
        fifoTolerance?: integer | string;
        fifoGapUnit?: UnitLength;
        netWeight?: decimal | string;
        netVolume?: decimal | string;
        pureAlcoholVolume?: decimal | string;
        price?: decimal | string;
        material?: string;
        minimumStock?: decimal | string;
        alertStock?: decimal | string;
        maximumStock?: decimal | string;
        firstArrival?: string;
        lastReceipt?: string;
        lastOutput?: string;
        lastStockCount?: string;
        defaultContainer?: string;
        defaultContainerLevel?: ContainerLevel;
        transmittedFromL3?: TransmissionL3;
        endOfLife?: string;
        isQualityControlManagement?: boolean | string;
        stockStatus?: string;
        isSingleLotControl?: boolean | string;
        samplingType?: SamplingType;
        generalLevelOfInspection?: string;
        aql?: decimal | string;
        freezingPoint?: integer | string;
        freezingReversibility?: ReversibleFreezing;
        ammNo?: string;
        referredQuantity?: decimal | string;
        referredUnit?: string;
        icpeClass?: string;
        flashPoint?: integer | string;
        transportCategory?: string;
        hazardousMaterialClass?: string;
        tunnelRestriction?: string;
        classificationCode?: string;
        packagingGroup?: PackagingGroup;
        onuCodes?: string;
        solventCode?: string;
        technicalField?: string;
        isActive?: boolean | string;
        isStockUnitManagement?: boolean | string;
        stockUnit?: string;
        siteDepositorIdentifier?: string;
        picture?: BinaryStream;
        activeMatters?: Partial<ProductActiveMattersInput>[];
        isPrintableDescriptions?: Partial<ProductIsPrintableDescriptionsInput>[];
        percentageActiveMatters?: Partial<ProductPercentageActiveMattersInput>[];
        stockCount?: string;
    }
    export interface ProductBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        code: string;
        otherCode: string;
        localizedDescription: string;
        localizedDescription2: string;
        localizedShortDescription: string;
        family: Family;
        subFamily: SubFamily;
        group: Group;
        subGroup: SubGroup;
        isKeyInSerialNumber: boolean;
        stockCountClass: StockCountClass;
        numberStockCount: integer;
        isBlockedInInput: boolean;
        isBlockedInOutput: boolean;
        isBlockedInInput2: boolean;
        isBlockedInOutput2: boolean;
        isKeyInLotNumber: boolean;
        isSingleLot: boolean;
        isCrossDocking: boolean;
        isHazardousMaterials: boolean;
        isKeyInControlCode: boolean;
        fifoDateNature: FifoDate;
        source: Origin;
        inputMode: InputMode;
        outputMode: OutputMode;
        autoTransferMode: MovementType;
        detentionLength: integer;
        detentionUnit: UnitLength;
        useByDateLength: integer;
        useByDateUnit: UnitLength;
        sendByDateLength: integer;
        sendByDateUnit: UnitLength;
        sellByDateLength: integer;
        sellByDateUnit: UnitLength;
        fifoTolerance: integer;
        fifoGapUnit: UnitLength;
        netWeight: string;
        netVolume: string;
        pureAlcoholVolume: string;
        price: string;
        material: Risk;
        minimumStock: string;
        alertStock: string;
        maximumStock: string;
        firstArrival: string;
        lastReceipt: string;
        lastOutput: string;
        lastStockCount: string;
        defaultContainer: ProductContainer;
        defaultContainerLevel: ContainerLevel;
        transmittedFromL3: TransmissionL3;
        endOfLife: string;
        isQualityControlManagement: boolean;
        stockStatus: StockNature;
        isSingleLotControl: boolean;
        samplingType: SamplingType;
        generalLevelOfInspection: string;
        aql: string;
        freezingPoint: integer;
        freezingReversibility: ReversibleFreezing;
        ammNo: string;
        referredQuantity: string;
        referredUnit: UnitOfMeasure;
        icpeClass: IcpeClasses;
        flashPoint: integer;
        transportCategory: TransportCategory;
        hazardousMaterialClass: HazardousMaterialsClass;
        tunnelRestriction: string;
        classificationCode: string;
        packagingGroup: PackagingGroup;
        onuCodes: OnuCode;
        solventCode: string;
        technicalField: string;
        isActive: boolean;
        isStockUnitManagement: boolean;
        stockUnit: UnitOfMeasure;
        siteDepositorIdentifier: string;
        suppliersUpcs: ClientCollection<SupplierUpc>;
        productContainers: ClientCollection<ProductContainer>;
        picture: BinaryStream;
        activeMatters: ClientCollection<ProductActiveMattersBinding>;
        isPrintableDescriptions: ClientCollection<ProductIsPrintableDescriptionsBinding>;
        percentageActiveMatters: ClientCollection<ProductPercentageActiveMattersBinding>;
        stockObjects: ClientCollection<StockObject>;
        stockCount: StockCount;
    }
    export interface ProductExtension$Lookups {
        stockCount: QueryOperation<StockCount>;
    }
    export interface ProductExtension$Operations {
        lookups(dataOrId: string | { data: ProductInput }): ProductExtension$Lookups;
    }
    export interface SerialNumberExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        inputAdjustment: AdjustmentMovement;
        outputAdjustment: AdjustmentMovement;
        transfer: TransferMovement;
        transferMovement: TransferMovement;
    }
    export interface SerialNumberInputExtension {
        site?: string;
        depositor?: string;
        product?: string;
        code?: string;
        double?: integer | string;
        occurrence?: integer | string;
        linePointerNumber?: integer | string;
        receiptDate?: string;
        deliveryOrderLineNumber?: integer | string;
        outputDate?: string;
        transmittedToL3?: integer | string;
        stockObject?: string;
        serialGroup?: string;
        validatedStoringList?: integer | string;
        validatedPreparationOrder?: integer | string;
        serialParentGroup?: string;
        transferDate?: string;
        free1?: string;
        free2?: string;
        free3?: string;
        free4?: string;
        free5?: string;
        voided?: integer | string;
        postponed?: integer | string;
        actionImport?: string;
        inputAdjustment?: string;
        outputAdjustment?: string;
        transfer?: string;
        transferMovement?: string;
    }
    export interface SerialNumberBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        depositor: Depositor;
        product: Product;
        code: string;
        double: integer;
        occurrence: integer;
        linePointerNumber: integer;
        receiptDate: string;
        deliveryOrderLineNumber: integer;
        outputDate: string;
        transmittedToL3: integer;
        stockObject: StockObject;
        serialGroup: SerialGroup;
        validatedStoringList: integer;
        validatedPreparationOrder: integer;
        serialParentGroup: SerialGroup;
        transferDate: string;
        free1: string;
        free2: string;
        free3: string;
        free4: string;
        free5: string;
        voided: integer;
        postponed: integer;
        displayCode: string;
        keyCodeForDuplicates: string;
        actionImport: string;
        inputAdjustment: AdjustmentMovement;
        outputAdjustment: AdjustmentMovement;
        transfer: TransferMovement;
        transferMovement: TransferMovement;
    }
    export interface SerialNumberExtension$Lookups {
        inputAdjustment: QueryOperation<AdjustmentMovement>;
        outputAdjustment: QueryOperation<AdjustmentMovement>;
        transfer: QueryOperation<TransferMovement>;
        transferMovement: QueryOperation<TransferMovement>;
    }
    export interface SerialNumberExtension$Operations {
        lookups(dataOrId: string | { data: SerialNumberInput }): SerialNumberExtension$Lookups;
    }
    export interface StockObjectExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevels>;
        adjustment: AdjustmentMovement;
    }
    export interface StockObjectInputExtension {
        site?: string;
        code?: string;
        depositor?: string;
        product?: string;
        store?: string;
        location?: string;
        storeType?: StoreType;
        locationType?: LocationType;
        containerNumber?: string;
        lotNumber?: string;
        supportNumber?: string;
        container?: string;
        containerCoefficient?: decimal | string;
        numberOfConsumptionUnit?: decimal | string;
        numberOfContainer?: decimal | string;
        numberOfConsumptionUnitInPendingInput?: decimal | string;
        numberOfConsumptionUnitInPendingOutput?: decimal | string;
        stockStatus?: string;
        reservationNumber?: string;
        source?: string;
        stockObjectLinkNumber?: string;
        fifoDate?: string;
        receiptDate?: string;
        manufacturedDate?: string;
        detentionDate?: string;
        sellByDate?: string;
        useByDate?: string;
        shipByDate?: string;
        unStockingAllocationSequence?: integer | string;
        storingDate?: string;
        storingTime?: integer | string;
        homogeneousContainer?: string;
        homogeneousContainerCoefficient?: decimal | string;
        homogeneousQuantity?: decimal | string;
        quantityInContainerCorrespondence?: decimal | string;
        serialNumbers?: Partial<SerialNumberInput>[];
        containerLevels?: Partial<StockObjectContainerLevelsInput>[];
        adjustment?: string;
    }
    export interface StockObjectBindingExtension {
        _updateUser: SysUser;
        _createUser: SysUser;
        site: Site;
        code: string;
        depositor: Depositor;
        product: Product;
        store: Store;
        location: Location;
        storeType: StoreType;
        locationType: LocationType;
        containerNumber: string;
        lotNumber: string;
        supportNumber: string;
        container: ProductContainer;
        containerCoefficient: string;
        numberOfConsumptionUnit: string;
        numberOfContainer: string;
        numberOfConsumptionUnitInPendingInput: string;
        numberOfConsumptionUnitInPendingOutput: string;
        stockStatus: StockNature;
        reservationNumber: string;
        source: Origin;
        stockObjectLinkNumber: string;
        fifoDate: string;
        receiptDate: string;
        manufacturedDate: string;
        detentionDate: string;
        sellByDate: string;
        useByDate: string;
        shipByDate: string;
        unStockingAllocationSequence: integer;
        storingDate: string;
        storingTime: integer;
        homogeneousContainer: ProductContainer;
        homogeneousContainerCoefficient: string;
        homogeneousQuantity: string;
        quantityInContainerCorrespondence: string;
        serialNumbers: ClientCollection<SerialNumber>;
        containerLevels: ClientCollection<StockObjectContainerLevelsBinding>;
        adjustment: AdjustmentMovement;
    }
    export interface StockObjectExtension$Lookups {
        adjustment: QueryOperation<AdjustmentMovement>;
    }
    export interface StockObjectExtension$Operations {
        lookups(dataOrId: string | { data: StockObjectInput }): StockObjectExtension$Lookups;
    }
    export interface Package {
        '@sage/wh-stock/AdjustmentMovementFinalsAndInitialsValues': AdjustmentMovementFinalsAndInitialsValues$Operations;
        '@sage/wh-stock/AdjustmentMovement': AdjustmentMovement$Operations;
        '@sage/wh-stock/AssemblingMovementContainerLevels': AssemblingMovementContainerLevels$Operations;
        '@sage/wh-stock/AssemblingMovement': AssemblingMovement$Operations;
        '@sage/wh-stock/AssemblingOrderLine': AssemblingOrderLine$Operations;
        '@sage/wh-stock/AssemblingOrder': AssemblingOrder$Operations;
        '@sage/wh-stock/AssemblingWave': AssemblingWave$Operations;
        '@sage/wh-stock/CountLine': CountLine$Operations;
        '@sage/wh-stock/Counting': Counting$Operations;
        '@sage/wh-stock/KitDeclaration': KitDeclaration$Operations;
        '@sage/wh-stock/SerialNumberCountingLine': SerialNumberCountingLine$Operations;
        '@sage/wh-stock/SimplifiedStockCountLine': SimplifiedStockCountLine$Operations;
        '@sage/wh-stock/SimplifiedStockCount': SimplifiedStockCount$Operations;
        '@sage/wh-stock/StockCountCampaign': StockCountCampaign$Operations;
        '@sage/wh-stock/StockCountLinesByLocation': StockCountLinesByLocation$Operations;
        '@sage/wh-stock/StockCountLinesByProduct': StockCountLinesByProduct$Operations;
        '@sage/wh-stock/StockCount': StockCount$Operations;
        '@sage/wh-stock/StockImage': StockImage$Operations;
        '@sage/wh-stock/TransferMovementContainerLevels': TransferMovementContainerLevels$Operations;
        '@sage/wh-stock/TransferMovement': TransferMovement$Operations;
    }
    export interface GraphApi
        extends Package,
            SageWhMasterData$Package,
            SageWhProductData$Package,
            SageWhStockData$Package,
            SageWhStructure$Package,
            SageWhSystem$Package,
            SageXtremAppMetadata$Package,
            SageXtremX3SystemUtils$Package {}
}
declare module '@sage/wh-stock-api' {
    export type * from '@sage/wh-stock-api-partial';
}
declare module '@sage/wh-master-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-structure-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-system-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/wh-stock-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/wh-master-data-api-partial' {
    import type {
        LocationBindingExtension,
        LocationExtension,
        LocationExtension$Lookups,
        LocationExtension$Operations,
        LocationInputExtension,
    } from '@sage/wh-stock-api';
    export interface Location extends LocationExtension {}
    export interface LocationBinding extends LocationBindingExtension {}
    export interface LocationInput extends LocationInputExtension {}
    export interface Location$Lookups extends LocationExtension$Lookups {}
    export interface Location$Operations extends LocationExtension$Operations {}
}
declare module '@sage/wh-product-data-api-partial' {
    import type {
        ProductBindingExtension,
        ProductExtension,
        ProductExtension$Lookups,
        ProductExtension$Operations,
        ProductInputExtension,
    } from '@sage/wh-stock-api';
    export interface Product extends ProductExtension {}
    export interface ProductBinding extends ProductBindingExtension {}
    export interface ProductInput extends ProductInputExtension {}
    export interface Product$Lookups extends ProductExtension$Lookups {}
    export interface Product$Operations extends ProductExtension$Operations {}
}
declare module '@sage/wh-stock-data-api-partial' {
    import type {
        SerialNumberBindingExtension,
        SerialNumberExtension,
        SerialNumberExtension$Lookups,
        SerialNumberExtension$Operations,
        SerialNumberInputExtension,
        StockObjectBindingExtension,
        StockObjectExtension,
        StockObjectExtension$Lookups,
        StockObjectExtension$Operations,
        StockObjectInputExtension,
    } from '@sage/wh-stock-api';
    export interface SerialNumber extends SerialNumberExtension {}
    export interface SerialNumberBinding extends SerialNumberBindingExtension {}
    export interface SerialNumberInput extends SerialNumberInputExtension {}
    export interface SerialNumber$Lookups extends SerialNumberExtension$Lookups {}
    export interface SerialNumber$Operations extends SerialNumberExtension$Operations {}
    export interface StockObject extends StockObjectExtension {}
    export interface StockObjectBinding extends StockObjectBindingExtension {}
    export interface StockObjectInput extends StockObjectInputExtension {}
    export interface StockObject$Lookups extends StockObjectExtension$Lookups {}
    export interface StockObject$Operations extends StockObjectExtension$Operations {}
}
