"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDbWrapper = void 0;
const client_dynamodb_1 = require("@aws-sdk/client-dynamodb");
const AWS_REGION = process.env.AWS_REGION;
const fullQualifiedSWFEndpoint = `https://dynamodb.${AWS_REGION}.amazonaws.com.`; // tailing "." to force FQDN
class DynamoDbWrapper {
    constructor(awsConfig, mock) {
        this.isLocal = false;
        this.queueUrl = "";
        const config = { ...awsConfig, endpoint: fullQualifiedSWFEndpoint };
        this.dynamoDB = mock || new client_dynamodb_1.DynamoDB(config);
    }
    async query(dbParams) {
        return this.dynamoDB.query(dbParams);
    }
}
exports.DynamoDbWrapper = DynamoDbWrapper;
