/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebSocketNotificationManager=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_websocket_emiter_1=require("@sage/xtrem-websocket-emiter"),cookie=require("cookie"),jwt_decode_1=require("jwt-decode"),ws_1=require("ws"),web_socket_emitter_repository_1=require("./web-socket-emitter-repository"),logger=xtrem_core_1.Logger.getLogger(__filename,"web-socket-notification");class WebSocketNotificationManager{static{this.webSocketNotificationClients=new Map}static identifyDevelopmentUser(e){const t=xtrem_core_1.ConfigManager.current,o=e.headers?.cookie;if(o){const e=cookie.parse(o);if(e.access_token){const t=(0,jwt_decode_1.jwtDecode)(e.access_token);if(t?.sub)return t.sub}}if(t.email)return t.email;return xtrem_core_1.Test.defaultEmail}static startDevelopmentService(e){if("development"!==xtrem_core_1.ConfigManager.current.deploymentMode)return;WebSocketNotificationManager.webSocketServer=new ws_1.WebSocket.Server({noServer:true}),WebSocketNotificationManager.webSocketServer.on("connection",(e,t)=>{const o=`${WebSocketNotificationManager.identifyDevelopmentUser(t)}-${t.headers["sec-websocket-key"]}`;WebSocketNotificationManager.addWebSocketNotificationClient(e,o),e.on("message",e=>{logger.info(`Received message from client ${o}: ${e.toString()}`)}),e.on("close",()=>{logger.info(`Client ${o} disconnected`),WebSocketNotificationManager.deleteWebSocketNotificationClient(o)}),e.send(`Connection established with ${o}`)}),e.on("upgrade",(e,t,o)=>{const i=e.headers.host;if(i?.startsWith("websocket."))WebSocketNotificationManager.webSocketServer.handleUpgrade(e,t,o,t=>{WebSocketNotificationManager.webSocketServer.emit("connection",t,e)});else t.destroy()})}static addWebSocketNotificationClient(e,t){if(WebSocketNotificationManager.webSocketNotificationClients.get(t))return;WebSocketNotificationManager.webSocketNotificationClients.set(t,e)}static deleteWebSocketNotificationClient(e){WebSocketNotificationManager.webSocketNotificationClients.delete(e)}static getWebSocketNotificationClient(e){const t=[];return WebSocketNotificationManager.webSocketNotificationClients.forEach((o,i)=>{if(i.startsWith(e))t.push(o)}),t}static getWebSocketNotificationClients(){return[...WebSocketNotificationManager.webSocketNotificationClients.values()]}static async sendUserNotification(e,t,o){const i=xtrem_core_1.ConfigManager.current,r=await e.loginUser,n=r?.email,c=r?._id;if(!n)return void logger.error(`Cannot send notification: No valid user email found in context for user id ${c}`);const a=e.tenantId;if(!a)return void logger.error(`Cannot send notification: No valid tenantId found in context for user id ${c}`);const s={category:t,payload:o};if("development"===i.deploymentMode){if(!WebSocketNotificationManager.webSocketServer&&!e.testMode)return void logger.error("No WebServer started. Please run WebSocketNotificationManager.startDevelopmentService");const t=WebSocketNotificationManager.getWebSocketNotificationClient(n);if(0===t?.length)logger.warn(`No websocket clients connected for user ${c}.`);return void t?.forEach(e=>{e?.send(JSON.stringify(s))})}if("production"===i.deploymentMode){const e={userId:n,tenantId:a,sendToAllMatchingUserSessions:true},t=WebSocketNotificationManager.webSocketHelper(i);if(await t.isUserOfTenantConnected({userId:n,tenantId:a}))await t.sendUserNotification(e,s);else logger.warn(()=>`Notification not sent: user ${c} not connected`)}}static async broadcast(e){const t=e.tenantId;if(!t)return void logger.error("Cannot broadcast message: No valid tenantId found.");const o=xtrem_core_1.ConfigManager.current;if("development"===o.deploymentMode){if(!WebSocketNotificationManager.webSocketServer)return void logger.error("No WebServer started. Please run WebSocketBroadcastManager.startService");const i=WebSocketNotificationManager.getWebSocketNotificationClients();if(0===i?.length)logger.warn("No websocket clients connected for broadcast.");const r={dynamoDBTableName:"",clusterId:o.clusterId??"",app:xtrem_core_1.ConfigManager.current.app??"sdmo",websocketSource:"",websocketQueueUrl:"",awsConfigOverride:{region:process.env.AWS_REGION||"eu-west-1"}},n=new web_socket_emitter_repository_1.WebSocketEmitterRepository(r),c={tenantId:t};return void await n.broadcastMessage(c,e)}if("production"===o.deploymentMode){const i=o.webSocket?.clientNotifications;if(!i)return void logger.error("Web socket request config is missing for clientNotifications");try{const i=WebSocketNotificationManager.webSocketHelper(o),r={tenantId:t};await i.broadcastMessage(r,e)}catch(e){logger.error(`Broadcasting message error: ${e.message}`)}}}static webSocketHelper(e){const t=e.webSocket?.clientNotifications;if(!t)throw new Error("Web socket request config is missing for clientNotifications");return new xtrem_websocket_emiter_1.WebsocketAWSImpl.WebsocketAWSRepository({app:xtrem_core_1.ConfigManager.current.app??"sdmo",source:t?.request?.source,clusterId:e.clusterId??"",dynamoDBTableName:t?.dynamoDbTableName??"",websocketQueueUrl:t?.request?.websocketQueueUrl??"",awsConfigOverride:{region:process.env.AWS_REGION||"eu-west-1"}})}}exports.WebSocketNotificationManager=WebSocketNotificationManager;
//# sourceMappingURL=web-socket-notification-manager.js.map