import { Context, UiBroadcastMessage } from '@sage/xtrem-core';
import { NotificationPayload } from '@sage/xtrem-shared';
import * as http from 'http';
import * as https from 'https';
import { WebSocket } from 'ws';
export declare class WebSocketNotificationManager {
    private static readonly webSocketNotificationClients;
    private static webSocketServer;
    static identifyDevelopmentUser(req: Request): string;
    static startDevelopmentService(httpServer: http.Server | https.Server): void;
    private static addWebSocketNotificationClient;
    private static deleteWebSocketNotificationClient;
    private static getWebSocketNotificationClient;
    static getWebSocketNotificationClients(): WebSocket[] | undefined;
    static sendUserNotification(context: Context, category: 'test' | 'userNotification' | 'tracking' | 'asyncMutationComplete', payload?: NotificationPayload): Promise<void>;
    /**
     * Broadcast a message to all users
     */
    static broadcast(payload: UiBroadcastMessage): Promise<void>;
    private static webSocketHelper;
}
//# sourceMappingURL=web-socket-notification-manager.d.ts.map