/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.WebSocketManager=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_websocket_emiter_1=require("@sage/xtrem-websocket-emiter"),nanoid_1=require("nanoid"),ws_1=require("ws"),axios=xtrem_core_1.Mocker.get("axios",require),logger=xtrem_core_1.Logger.getLogger(__filename,"web-socket");class WebSocketManager{static{this.wsClients=new Map}static start(e,r){if(this.wsClients.has(r))return void logger.error(`Websocket client already started : ${r}`);const o=xtrem_core_1.ConfigManager.current.webSocket&&xtrem_core_1.ConfigManager.current.webSocket[r];if(!o)return void logger.error(`Web socket config is missing for ${r}`);WebSocketManager.createWebSocketClient(e,r,o)}static getUploadUrl(e,r){return logger.info(`Fetching an upload url for contextid : ${r}`),(0,xtrem_core_1.withRethrow)(async()=>{const o=await axios.post(`${e}${r}`);if(201===o?.status)return logger.info(`Upload url response : ${JSON.stringify(o.data)}`),{uploadUrl:o.data.uploadUrl,confirmUrl:o.data.confirmUrl};throw new Error(`API to get presigned url returned with a ${o.status} status`)},e=>(logger.error(`Error while fetching upload URL: \n${e.message}`),new xtrem_core_1.SystemError("Error while fetching upload URL",e)))}static async sendResponsePayload(e,r,o){const t=await this.getUploadUrl(e,r);await(0,xtrem_core_1.withRethrow)(async()=>{const e=await axios.put(t.uploadUrl,o);if(200!==e.status)logger.error(`upload to s3 failed: ${e.status}`)},e=>(logger.error(`upload to s3 failed: ${e.message}`),new xtrem_core_1.SystemError(`upload to s3 failed: uploadUrl=${t.uploadUrl}`,e))),logger.info("upload to s3 done"),await(0,xtrem_core_1.withRethrow)(async()=>{const e=await axios.post(t.confirmUrl);if(200!==e.status)logger.error(`Fail to confirm upload done : ${e.status}`)},e=>(logger.error(`Fail to confirm upload done: ${e.message}`),new xtrem_core_1.SystemError(`Fail to confirm upload done: confirmUrl=${t.confirmUrl}`,e))),logger.info(`Confirmation of upload completed, end of processing ${r}`)}static createWebSocketClient(e,r,o){if(!o.response)return void logger.error(`Web socket response config is missing for ${r}`);const t=new ws_1.WebSocket(o.response.wsEndPoint,{headers:{Authorization:o.response.authToken},perMessageDeflate:false});t.on("open",()=>{logger.info(`Connected to ${r} web socket endpoint`)}),t.on("close",()=>{logger.info(`Server sent close event, reconnecting to ${r}`),WebSocketManager.createWebSocketClient(e,r,o)}),t.on("error",()=>{logger.info(`Server sent error event, reconnecting to ${r}`),setTimeout(()=>WebSocketManager.createWebSocketClient(e,r,o),5e3)});const processMessage=async t=>{logger.info(`received(${r}): ${t}`);let n=null;n=JSON.parse(t.toString());const s=["contextId","tenantId","developerId","source","type","request","replyId","replyTopic"].filter(e=>!n[e]);if(s.length>0)throw new Error(`Message missing, ${s} : ${n}`);if(logger.info(`Message format valid, contextId : ${n.contextId}, tenantId : ${n.tenantId}`),!xtrem_core_1.CoreHooks.webSocketHandlers[r])throw new Error(`Web socket handler missing for key : ${r}`);const a=JSON.stringify(await xtrem_core_1.CoreHooks.webSocketHandlers[r].getResponse(e,n));if(logger.info(`response = ${a}`),o.response)await WebSocketManager.sendResponsePayload(o.response.restResponseEndpoint,n.contextId,a);else logger.error(`Web socket response config is missing for ${r}`)};t.on("message",e=>(0,xtrem_core_1.asyncFireAndForget)(()=>processMessage(e),"Error sending response message",logger)),this.wsClients.set(r,t)}static getRegion(){return process.env.AWS_REGION||"eu-west-1"}static async send(e,r,o,t,n){logger.info(`Websocket - sending message on key ${e}`);const s=xtrem_core_1.ConfigManager.current,a=s.webSocket&&s.webSocket[e];if(!a?.request)throw new Error(`Web socket request config is missing for ${e}`);logger.info(`Searching if app ${t} is connected for tenant ${o}  (cluster context ${s.clusterId})`);const i=new xtrem_websocket_emiter_1.WebsocketAWSImpl.WebsocketAWSRepository({app:xtrem_core_1.ConfigManager.current.app||"",source:a.request.source,clusterId:s.clusterId||"",dynamoDBTableName:s.asyncContextTableName||"",websocketQueueUrl:a.request.websocketQueueUrl,awsConfigOverride:{region:this.getRegion()}}),c=(0,nanoid_1.nanoid)(),g={...r,contextId:c};if(await i.isThirdPartyAppConnected({tenantId:o,applicationId:t}))return logger.info(`3rd party app connected, message : ${JSON.stringify(g)}`),await i.sendThirdPartyAppNotification({applicationId:t,tenantId:o},g),logger.info(`Message sent: ${c}`),c;if(logger.error("The 3rd party app is not connected via websocket at the moment"),n?.force)return logger.warn(`Forcing message sending to user anyway : ${JSON.stringify(g)}`),await i.sendThirdPartyAppNotification({applicationId:t,tenantId:o},g),logger.warn(`Message sent, forced, not sure it will be received: ${c}`),c;throw new Error("Web socket request not sent, 3rd party app not connected.")}static startService(e){const r=e.startOptions.webSockets||[];if(r.length>0)logger.info(`Starting web sockets: ${r}`),r.forEach(r=>{WebSocketManager.start(e,r)})}}exports.WebSocketManager=WebSocketManager;
//# sourceMappingURL=web-socket-manager.js.map