import { AnyValue, Application, Dict } from '@sage/xtrem-core';
export interface RestResponseInfo {
    uploadUrl: string;
    confirmUrl: string;
}
export interface WebSocketRequestData {
    tenantId: string;
    developerId: string;
    request: string;
    locale: string;
    type: string;
    source: string;
    replyId: string;
    replyTopic: string;
    attributes: Dict<AnyValue>;
}
export declare class WebSocketManager {
    private static readonly wsClients;
    /**
     * Start web socket client for the specified config key
     * @param application
     * @param key
     */
    static start(application: Application, key: string): void;
    /**
     * Fetch the upload url and confirm url for the specified contextId
     * @param restResponseEndpoint
     * @param contextId
     * @returns
     */
    private static getUploadUrl;
    /**
     * send the response message to the upload URL and confirm the upload with a post to the confirm URL
     * @param restResponseEndpoint
     * @param contextId
     * @param response
     */
    private static sendResponsePayload;
    private static createWebSocketClient;
    private static getRegion;
    /**
     * Send a message to a web socket
     */
    static send(key: string, data: WebSocketRequestData, tenantId: string, applicationId: string, options?: {
        force?: boolean;
    }): Promise<string>;
    static startService(application: Application): void;
}
//# sourceMappingURL=web-socket-manager.d.ts.map