import { WebsocketAWSRepositoryConfig, WebsocketRepository } from '@sage/xtrem-websocket-emiter';
import { BroadcastMessageTarget, ConnectedThirdPartyAppCriteria, ConnectedUserCriteria, MessageTarget, MessageThirdPartyAppTarget } from '@sage/xtrem-websocket-emiter/out/business/websocketRepository';
/** *
 * Local mode implementation for xtrem-websocket-emitter WebsocketAWSRepository
 * https://github.com/Sage-ERP-X3/xtrem-deployment/blob/master/npm_modules/xtrem-websocket-emiter/src/business/impl/websocketAWSRepository.ts
 * This is done in order to mimic the usage of the library locally
 */
export declare class WebSocketEmitterRepository extends WebsocketRepository {
    private readonly config;
    constructor(config: WebsocketAWSRepositoryConfig);
    broadcastMessage(sendTo: BroadcastMessageTarget, payload: any): Promise<void>;
    isUserOfTenantConnected(connectedUserFilter: ConnectedUserCriteria, _acrossAllApps?: boolean): Promise<boolean>;
    sendUserNotification(_sendTo: MessageTarget, _payload: any): Promise<void>;
    isThirdPartyAppConnected(connectedAppFilter: ConnectedThirdPartyAppCriteria, _acrossAllApps?: boolean): Promise<boolean>;
    sendThirdPartyAppNotification(_sendTo: MessageThirdPartyAppTarget, _payload: any): Promise<void>;
}
//# sourceMappingURL=web-socket-emitter-repository.d.ts.map