/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.PluginLoader=exports.logger=void 0;const xtrem_cli_lib_1=require("@sage/xtrem-cli-lib"),xtrem_log_1=require("@sage/xtrem-log"),find_up_1=require("find-up"),fs=require("fs"),glob=require("glob"),_=require("lodash"),path=require("path");exports.logger=new xtrem_log_1.Logger(__filename,"cli");class PluginLoader{#e=[];#r="";constructor(){}static getInstance(){if(!PluginLoader.instance)PluginLoader.instance=new PluginLoader;return PluginLoader.instance.init()}async init(){const e=await(0,find_up_1.findUp)("package.json");return this.#r=e?`${path.dirname(e)}/node_modules`:"./node_modules",this.#e=[this.#r],this}autoDiscoverPlugins(){exports.logger.info(`Auto-discovering plugins from ${process.cwd()} in ${this.#r}...`);const e=require.main?.path??"",r=[];r.push(`${this.#r}/@sage/*-cli-*/package.json`);const n=glob.sync(r);exports.logger.debug(()=>`found packages: ${JSON.stringify(n,null,2)}`);const t=n.map(e=>this.tryReadPackage(e)).filter(e=>null!=e&&e.name),o=t.filter(e=>e.name.includes("-cli-bundle-"));if(o.length>0){exports.logger.debug(()=>`bundles: ${o.map(e=>e.name)}`);const e=o.map(e=>this.tryRequirePackage(`${e.name}/package.json`)).filter(e=>null!=e),r=e.map(e=>path.join(this.#r,e.name,"node_modules"));this.#e=_.uniq([...r,...this.#e,...module.paths]);const n=_.uniq(e.map(e=>Object.keys(e.dependencies??{}).filter(e=>e.includes("-cli-"))).flat());exports.logger.debug(()=>`bundle packages: ${n}`);n.map(e=>this.tryRequirePackage(`${e}/package.json`)).filter(e=>null!=e).forEach(e=>{if(e&&!t.find(r=>r.name===e.name))exports.logger.debug(()=>`add extra pack: ${e?.name}`),t.push(e)})}return _.uniq(t.filter(r=>!r.name.includes("-cli-bundle-")&&!e.includes(`/${r.name}/`)&&Object.keys({...r.dependencies,...r.peerDependencies}).includes("@sage/xtrem-cli-lib")).map(e=>e.name))}tryReadPackage(e){try{const r=fs.readFileSync(e,"utf8");return JSON.parse(r)}catch(e){if("ENOENT"!==e.code)throw e;return null}}tryRequire(e,r){try{const n=this.#e.reduce((r,n)=>{if(r)return r;return require.resolve(e,{paths:[n]})},null);if(null==n)return exports.logger.error(`${r?.cannotResolve??"Cannot resolve package"} '${e}': Not Found`),null;return require(n)}catch(n){if("MODULE_NOT_FOUND"!==n.code)throw n;return exports.logger.error(`${r?.cannotRequire??"Cannot require package"} '${e}': ${n.message}`),null}}tryRequirePackage(e){return this.tryRequire(e,{cannotResolve:"Cannot resolve package",cannotRequire:"Cannot require package"})}tryLoadPlugin(e){return{name:e,exports:this.tryRequire(e,{cannotResolve:"Cannot resolve plugin",cannotRequire:"Cannot load plugin"})??{}}}loadPlugins(e,r){let n=r?.cli?.plugins;if(null==n)n=this.autoDiscoverPlugins();exports.logger.info(`Plugins to load: [${n}]`),n?.map(e=>this.tryLoadPlugin(e)).filter(e=>n?.includes(e.name)).forEach(r=>{const n=r.exports.plugin;if("function"==typeof n){xtrem_cli_lib_1.pluginRegistry.add(r),exports.logger.verbose(()=>`Try loading plugin... ${r.name}`);try{n(e)}catch(e){exports.logger.warn(`Failed to load plugin ${r.name}, reason = ${e.message}`)}}});const t=xtrem_cli_lib_1.pluginRegistry.plugins;e.config({$cli:{plugins:t}}),exports.logger.info(`Loaded plugins [${t.map(e=>e.name)}]`)}}exports.PluginLoader=PluginLoader;
//# sourceMappingURL=plugin-loader.js.map