/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_log_1=require("@sage/xtrem-log"),config_1=require("./config"),plugin_loader_1=require("./plugin-loader");function exitOnUnhandledError(e){if(xtrem_core_1.globalRunningContext.isServicesMode)return;plugin_loader_1.logger.error(e()),process.exit(1)}process.on("uncaughtException",e=>{exitOnUnhandledError(()=>`Uncaught exception: ${e.stack}`)}).on("unhandledRejection",(e,r)=>{exitOnUnhandledError(()=>`Unhandled rejection: ${e} at ${r}`)}),(0,xtrem_log_1.sourceMapSetup)(),(async()=>{const e=require("yargs/yargs")(process.argv.slice(2).filter(e=>"--"!==e),process.cwd()),r=(0,config_1.loadConfig)(),o=await plugin_loader_1.PluginLoader.getInstance();await o.loadPlugins(e,r),await e.wrap(e.terminalWidth()).scriptName("xtrem").usage("Usage: $0 <command> [options]").demandCommand(1,"You need at least one command before moving on").option("verbose",{alias:"d",desc:"Verbose output",default:false,global:true}).env("XTREM").help("h").alias("h","help").alias("v","version").epilog("use $0 <command> --help for help on <command>").middleware(e=>{xtrem_core_1.globalRunningContext.init({argv:e})}).command({command:"*",handler:r=>{if(plugin_loader_1.logger.error(`Unhandled command '${r._}' from '${process.cwd()}'. Please be sure to run this command from an application directory and that the expected cli plugins are referenced in the package.json`),0===r.$cli?.plugins?.length)plugin_loader_1.logger.error("No plugins found");else console.log(""),e.showHelp();process.exit(1)}}).parse()})().catch(e=>{plugin_loader_1.logger.error(e.stack),process.exit(1)});
//# sourceMappingURL=cli.js.map