import { Logger } from '@sage/xtrem-log';
export declare function getLogger(filename: string, domain: string): Logger;
export interface ToolResponse {
    [x: string]: unknown;
    isError?: boolean;
    content: {
        type: 'text';
        text: string;
    }[];
}
export type Message = {
    role: 'user' | 'assistant' | 'system';
    content: string;
};
export declare function toolSuccess(texts: string[]): ToolResponse;
export declare function toolError(error: Error): ToolResponse;
export declare function getPackageDir(): string;
export declare function getPackageVersion(): `${number}.${number}.${number}`;
export declare const config: import("@sage/xtrem-shared/lib/config").Config;
export declare function capitalize(text: string): string;
export declare function ellipsesText(value: string, maxLength?: number): string;
export declare function ellipsesReplacer(_key: string, value: any): any;
//# sourceMappingURL=utils.d.ts.map