/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Prompts=void 0;class Prompts{static serverDescription(e,t){return`\nMCP server providing access to ${e} business application data via GraphQL API and providing user assistance which relies on static helper documentation.\n\nThis server exposes ${t.length} business data nodes for querying, filtering, sorting, and mutating. All data access respects the application's security permissions.\n\n**Required workflow for all data operations with GraphQL:**\n1. Call \`getApiDocumentation\` (once per session) to get GraphQL syntax rules and available node names\n2. Call \`getMetadata\` for specific nodes to understand their properties and relationships\n3. Use \`queryGraphql\` to execute data queries and mutations\n4. If the user asks for visualization of data, use \`addChartTool\` to generate chart data\n5. If the user asks for exporting data, use \`addCreateExportTool\` to generate export files\n\n**Required workflow for product support related user questions:**\nAssume that the user wants to achieve tasks using the application GUI, unless the user explicitly states they wish to use the API for that.\n1. Call \`getDocumentationTopics\` (once per session) to retrieve the list of the user support documentation pages\n2. Try to find the most relevant page for the user question\n3. Call \`getDocumentationPageContent\` with the selected topic to retrieve the content of the page\n4. Answer the user question using the content of the page. If no page is found, answer the user that no documentation is available for the question.\n`}static getApiDocumentationDescription(){return"**REQUIRED FIRST STEP**: Retrieves comprehensive GraphQL API documentation and available node names.\n\n**Purpose**: Provides essential syntax, filtering, sorting, pagination, and mutation patterns specific to XTreeM GraphQL queries, plus the complete list of available node names.\n\n**When to call**: Always call this tool first in any workflow - it contains critical syntax rules that differ from standard GraphQL and the authoritative list of queryable nodes.\n\n**Output**: Complete documentation including query structure, filtering operators, natural key usage, property flags, mutation patterns, and the complete list of available node names.\n\n# 🚨 CRITICAL: REQUIRED TOOL SEQUENCE\n\n**ALWAYS follow this exact sequence:**\n\n1. **getApiDocumentation** (once per session)\n2. **getMetadata** for ALL nodes you plan to query\n3. **getOperationMetadata** for any custom mutations\n4. **queryGraphql** to execute queries\n\n**❌ NEVER call queryGraphql without first getting metadata for all involved nodes**\n\n**Why:** GraphQL operations WILL FAIL without proper property validation and knowledge of operational flags."}static getMetadataDescription(){return"Retrieves detailed schema information for specific business data nodes.\n\n**Purpose**: Provides complete property lists, data types, relationships, and operational flags needed to construct valid GraphQL queries.\n\n**Input**: Array of node names (from API documentation) relevant to the user's request.\n\n**Output**: For each node, returns:\n- Property names, types, and descriptions\n- Relationship mappings to other nodes\n- Operational flags (Can filter, Can sort, Is output, Is input, Is required)\n- Natural key definitions\n- Package information\n\n**Critical**: Always call this tool before `queryGraphql` - queries will fail without proper property validation.\n\n**Best practice**: Request metadata for all nodes you plan to query, including related nodes for joins/filters.\n"}static getWorkflowDocumentationDescription(){return"Retrieves documentation for the management of workflows through the GraphQL API.\n\n**Purpose**: Provides detailed information on how to create, modify, and delete workflows using the GraphQL API.\n\n**Input**: empty. The tool does not require any input parameters.\n\n**Output**: A markdown-formatted string containing:\n- An overview of the mutations that you should use to create, update, or delete workflows.\n- A detailed description of the JSON format of workflow diagrams.\n\n**Critical**: Always call this tool before trying to create or modify a workflow with the `queryGraphql` tool.\nThe graphql mutations will fail if the workflow diagram does not conform to the expected JSON structure.\n"}static getOperationMetadataToolDescription(){return'Retrieves detailed metadata for specific node operations (mutations).\n\n**Purpose**: Provides parameter schemas and return types for custom business operations beyond standard CRUD mutations.\n\n**Input**:\n- `nodeName`: The target node (e.g., "salesOrder")\n- `operationName`: The specific operation (e.g., "approve", "cancel", "recalculate")\n\n**Output**:\n- Parameter schemas with types, validation rules, and requirement flags\n- Return value structure and available fields\n- Operation-specific constraints and business rules\n\n**When to use**: Required before executing custom mutations or complex business operations that aren\'t standard create/update/delete.\n'}static queryGraphqlDescription(){return"Executes GraphQL queries and mutations against the business application's data API.\n\n**Purpose**: Retrieves, filters, sorts, aggregates, creates, updates, and deletes business data using XTreeM-specific GraphQL syntax.\n\n**Input Parameters**:\n- `query`: Valid XTreeM GraphQL query or mutation string\n- `waitInSeconds` (optional): Delay before execution for async operations\n\n**Prerequisites** (execute in order):\n1. `getApiDocumentation` - Learn XTreeM GraphQL syntax rules\n2. `getMetadata` - Get property schemas for target nodes\n3. `getOperationMetadata` - For custom mutations, get operation schemas\n\n**Output**: Complete JSON response from GraphQL API, including data, errors, and metadata.\n\n⚠️ PREREQUISITES:\n- Must call getMetadata for all nodes used in this query first\n- Must call getOperationMetadata for any custom mutation used in this query\n\n**CRITICAL VALIDATION RULES**:\n- Use ONLY node names from API documentation - never guess or assume\n- Use ONLY properties from `getMetadata` - validate all field names\n- Respect property flags (Can filter, Can sort, Is output, Is input)\n- Follow XTreeM pagination model (edges/nodes, not direct arrays)\n- Exclude textStream/binaryStream properties unless specifically requested\n- Use natural key syntax (#value) for user-friendly references\n\n**Supported Operations**: Queries, aggregations, standard mutations (create/update/delete), and custom business operations with full filtering, sorting, and pagination support.\n"}static getDocumentationTopicsDescription(){return"Retrieves the list of topics available in the user support documentation.\n\n**Purpose**: Provides an overview of the topics covered in the documentation, helping users find relevant information quickly.\n\n**Input**: None\n\n**Output**: A list of documentation topics\n\n**Output**: A list of topic names, each representing a specific area of the user support documentation.\n\n**When to use**: Call this tool when the user asks for help with the product, such as how to achieve a specific task or when the user asks about product features.\n"}static getDocumentationPageContentDescription(){return"Retrieves the content of a documentation page based on a support topic\n\n**Purpose**: User support documentation which provides detailed information about a specific topic on how to use the product\n\n**Input**: The name of the topic\n\n**Output**: The content of the documentation page for the specified topic\n\n**When to use**: Call this tool when the user asks for help with a specific topic or needs detailed information about a feature or functionality.\n"}static addCreateExportTool(){return'Generates an exported CSV or Excel file based on user input.\n\n        **Purpose**: Generate a downloadable spreadsheet formatted file which contains the relevant data extracted from the application.\n\n        **Input Parameters**:\n          - nodeName: The name of the node to export data from (e.g., "Customer", "SalesOrder")\n          - outputFormat: The desired format for the exported file.\n          - templateDefinition: List of properties to include in the export. It is an array of objects, each with a dot-notated property `path` and a column `title`.\n          - filter: GraphQL filter statement to filter the list of records that are exported in JSON5-stringified format\n          - orderBy: GraphQL orderBy clause to sort the exported records in JSON5-stringified format\n\n        **Output**: A download link to the exported file\n\n        **When to use**: Call this tool whenever the user wishes to export table-like data such as lists. Before calling this tool verify the parameters by using the queryGraphql with a page size of 1.\n'}static addChartTool(){return'Generates input data for charts that visually represent data to the user.\n\n        **Purpose**: Generate standard output from the application data that can be used to create charts.\n\n        **Input Parameters**:\n          - chartType: The type of chart to generate (e.g., "bar", "line", "pie")\n          - baseAxis: The property name to use for the base axis (e.g., "date", "category")\n          - data: An array of objects, each with a key for the baseAxis value and other values for the data points. The data points must have the same keys across all objects.\n\n        **Output**: A JSON object containing the chart data, including labels and datasets. This will be later processed by a charting library to render the actual chart. It must be in the following JSON format wrapped into a Markdown code block, you must include the "chart-json" format identifier after the opening backticks:\n        ```chart-json\n        {\n          "chartType": "bar" | "line" | "pie",\n          "baseAxis": "baseAxisPropertyName",\n          "data":[\n            { "baseAxisPropertyName": "value1", "dataPoint1": number, "dataPoint2": number, ... },\n            { "baseAxisPropertyName": "value2", "dataPoint1": number, "dataPoint2": number, ... },\n            ...\n          ],\n        }\n        ```\n        **YOU MUST INCLUDE THE TOOL OUTPUT TO THE USER WITHOUT ANY MODIFICATION.**\n\n        **When to use**: Call this tool whenever the user wishes to visualize data in a chart format.\n'}static getInternalLinkDescription(){return'Generates an internal link to a specific record or a list of records within the application.\n\n        **Purpose**: Create a direct URL link that navigates to a specific record\'s detail view or a record list view, facilitating quick access.\n        **Input Parameters**:\n          - nodeName: The name of the node to link to (e.g., "Customer", "SalesOrder")\n          - filter: GraphQL filter statement to specify which records to include in the list view, in JSON5-stringified format. In case of direct record links, the filter should only contain the _id field. If omitted, the link will point to the general list view of the node.\n        '}}exports.Prompts=Prompts;
//# sourceMappingURL=prompts.js.map