/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MetadataManager=void 0;const fetch_js_1=require("./fetch.js"),metadata_formatter_js_1=require("./metadata-formatter.js"),utils_js_1=require("./utils.js"),logger=(0,utils_js_1.getLogger)(__filename,"fetch");class MetadataManager{#e={};#t={};#a={};#n={};#r=[];#s;constructor(e){this.options=e,this.#s=this.options.isProxy?"xtremAppMetadata":"xtremMetadata"}get endpoint(){return this.options.endpoint}getAuthorizationHeader(){return{Authorization:`Bearer ${this.options.bearerToken}`}}async fetchAllPages(e){const t=[];let a;for(;;){const{data:n,pageInfo:r}=await e(a);if(t.push(...n),a=r.endCursor,!r.hasNextPage)break}return t}async fetchDataTypesPage(e,t,a){const n=a?`after: ${JSON.stringify(a)},`:"",r=JSON.stringify(JSON.stringify({name:{_in:e}})),s=`\nquery {\n    ${this.#s} {\n        metaDataType {\n            query (first: ${t}, ${n} filter: ${r}) {\n                edges {\n                    node {\n                        name\n                        type\n                        attributes\n                    }\n                }\n                pageInfo {\n                    hasNextPage\n                    endCursor\n                }\n            }\n        }\n    }\n}`,o=await(0,fetch_js_1.rawQuery)({query:s,url:this.endpoint,headers:this.getAuthorizationHeader(),locale:this.options.userLocale,endpoint:this.options.apiRoute});if(!o)throw new Error("Failed to fetch metadata");const i=o.data[this.#s].metaDataType.query.pageInfo;return{data:o.data[this.#s].metaDataType.query.edges.map(e=>({...e.node})),pageInfo:i}}nodesFilter(e){const t={isPublished:true,isAbstract:false};if(e)t.name={_in:e};return JSON.stringify(JSON.stringify(t))}async fetchAllNodeNamesPage(e,t){const a=t?`after: ${JSON.stringify(t)},`:"",n=`\nquery {\n    ${this.#s} {\n        metaNodeFactory {\n            query (\n            first: ${e},\n            ${a}\n            filter: ${this.nodesFilter(null)}) {\n                edges {\n                    node {\n                        name\n                    }\n                }\n                pageInfo {\n                    hasNextPage\n                    endCursor\n                }\n\n            }\n        }\n    }\n}`,r=await(0,fetch_js_1.rawQuery)({query:n,url:this.endpoint,headers:this.getAuthorizationHeader(),locale:this.options.userLocale,endpoint:this.options.apiRoute});if(!r)throw new Error("Failed to fetch metadata");return{data:r.data[this.#s].metaNodeFactory.query.edges.map(e=>e.node.name),pageInfo:r.data[this.#s].metaNodeFactory.query.pageInfo}}async fetchNodesMetadataPage(e,t,a){const n=a?`after: ${JSON.stringify(a)},`:"",r="canCreate canUpdate canDelete canDuplicate",s="hasDefaultValue",o=`\nquery {\n    ${this.#s} {\n        metaNodeFactory {\n            query (\n            first: ${t},\n            ${n}\n            filter: ${this.nodesFilter(e)}) {\n                edges {\n                    node {\n                        name\n                        package {\n                            name\n                        }\n                        ${r}\n                        naturalKey\n                        properties {\n                            # Fetch all properties at once with first: 1000\n                            query (first: 1000, filter: "{ isPublished: true }") {\n                                edges {\n                                    node {\n                                        name\n                                        type\n                                        targetFactory {\n                                            name\n                                        }\n                                        dataType {\n                                            name\n                                            type\n                                            attributes\n                                        }\n                                        isNullable\n                                        isRequired\n                                        isOnInputType\n                                        isOnOutputType\n                                        isVital\n                                        isVitalParent\n                                        canFilter\n                                        canSort\n                                        ${s}                                   }\n                                }\n                            }\n                        }\n                        operations {\n                            query (first: 1000, filter: "{ isPublished: true, isActive: true }") {\n                                edges {\n                                    node {\n                                        name\n                                        kind\n                                        action\n                                        isPublished\n                                        isMutation\n                                        parameters\n                                        return\n                                    }\n                                }\n                            }\n                        }\n                    }\n                }\n                pageInfo {\n                    hasNextPage\n                    endCursor\n                }\n            }\n        }\n    }\n}`,i=await(0,fetch_js_1.rawQuery)({query:o,url:this.endpoint,headers:this.getAuthorizationHeader(),locale:this.options.userLocale,endpoint:this.options.apiRoute});if(!i)throw new Error("Failed to fetch metadata");return{data:i.data[this.#s].metaNodeFactory.query.edges.map(e=>({canCreate:true,canUpdate:true,canDelete:true,canDuplicate:true,...e.node,properties:e.node.properties.query.edges.map(e=>({hasDefaultValue:!e.node.isRequired,...e.node})),operations:e.node.operations.query.edges.map(e=>({...e.node,parameters:JSON.parse(e.node.parameters||"[]"),return:JSON.parse(e.node.return||"{}")})),naturalKey:e.node.naturalKey?JSON.parse(e.node.naturalKey):null,dataTypeNames:new Set})),pageInfo:i.data[this.#s].metaNodeFactory.query.pageInfo}}async fetchAllNodeNames(){return this.fetchAllPages(async e=>this.fetchAllNodeNamesPage(50,e))}async fetchDataTypes(e){if(0===e.length)return[];return this.fetchAllPages(t=>this.fetchDataTypesPage(e,50,t))}async fetchNodesMetadata(e){return this.fetchAllPages(async t=>this.fetchNodesMetadataPage(e,50,t))}async fetchMissingMetadata(e){const t=await this.fetchNodesMetadata(e);for(const e of t)this.#e[e.name]=e;const a=this.collectNodesDataTypeNames(t).filter(e=>!this.#t[e]);if(a.length>0){const e=await this.fetchDataTypes(a);for(const t of e)this.#t[t.name]=t}for(const e of a){const t=this.#t[e];if(!t)throw new Error(`Data type '${e}' not found in metadata`);if("enum"===t.type&&!this.#a[t.name])this.#a[t.name]=metadata_formatter_js_1.MetadataFormatter.formatEnum(t)}}collectParamDataTypeNames(e,t){if("enum"===t.type){if(logger.error("ENUM PARAM:"+JSON.stringify(t)),!t.dataType)throw new Error(`Data type for enum '${t.name}' is missing`);e.dataTypeNames.add(t.dataType)}else if(Array.isArray(t.properties))t.properties.forEach(t=>this.collectParamDataTypeNames(e,t))}collectNodeDataTypeNames(e){for(const t of e.properties)if(t.dataType)e.dataTypeNames.add(t.dataType.name);for(const t of e.operations)t.parameters.forEach(t=>this.collectParamDataTypeNames(e,t)),this.collectParamDataTypeNames(e,t.return)}collectNodesDataTypeNames(e){let t=new Set;for(const a of e)this.collectNodeDataTypeNames(a),t=new Set([...t,...a.dataTypeNames]);return Array.from(t)}async getAllNodeNames(){if(this.#r.length>0)return this.#r;try{this.#r.push(...(await this.fetchAllNodeNames()).sort((e,t)=>e.localeCompare(t)))}catch(e){throw logger.error(`Failed to load metadata: ${e.stack||e.message}`),new Error("Failed to load metadata")}return this.#r}async loadMissingMetadata(e){const t=e.filter(e=>!this.#e[e]);if(t.length>0)await this.fetchMissingMetadata(t)}async getMetadataSections(e){await this.loadMissingMetadata(e);const t=[],a={};for(const n of e){const e=this.#e[n];if(!e)throw new Error(`Node '${n}' not found in metadata`);const r=`${e.package.name}/${n}`,s={...e,pageName:r};t.push(metadata_formatter_js_1.MetadataFormatter.formatNode(s));for(const t of e.dataTypeNames){const e=this.#t[t];if("enum"!==e?.type)continue;if(!this.#a[t])throw new Error(`Enum text for '${t}' not found in metadata`);a[t]=this.#a[t]}}return t.push(metadata_formatter_js_1.MetadataFormatter.formatEnums(Object.values(a))),t}async getMetadataText(e){try{const t=await this.getMetadataSections(e);return(0,utils_js_1.toolSuccess)(t)}catch(e){return logger.error(`Failed to get metadata text: ${e.stack||e.message}`),(0,utils_js_1.toolError)(e)}}async getOperationMetadataText(e,t){await this.loadMissingMetadata([e]);const a=this.#e[e];if(!a)throw new Error(`Node '${e}' not found in metadata`);const n=a.operations.filter(e=>e.name===t);if(!n.length)throw new Error(`Operation '${t}' not found in node '${e}' metadata`);let r=n[0];if(n[0].action){const a=n.find(e=>"start"===e.action),s=n.find(e=>"track"===e.action);if(!a||!s)throw new Error(`Async mutation '${t}' not fully defined in node '${e}' metadata`);r={...a,return:s.return}}return logger.error("Operation metadata:"+JSON.stringify(r)),metadata_formatter_js_1.MetadataFormatter.formatOperation(r)}async getOperationMetadata(e,t){try{const a=await this.getOperationMetadataText(e,t);return(0,utils_js_1.toolSuccess)([a])}catch(e){return(0,utils_js_1.toolError)(e)}}async createExportedList(e){const t=this.options.exportListOptions?.exportList;if(!t)return(0,utils_js_1.toolError)(new Error("Export list function not provided"));try{const a=await t(e,e=>(0,fetch_js_1.rawQuery)({query:e,url:this.endpoint,headers:this.getAuthorizationHeader(),locale:this.options.userLocale,endpoint:this.options.apiRoute}));return(0,utils_js_1.toolSuccess)([a])}catch(e){return(0,utils_js_1.toolError)(e)}}async getTunnelPageName(e){if(this.options.isProxy)return null;if(Object.prototype.hasOwnProperty.call(this.#n,e))return this.#n[e];const t=await(0,fetch_js_1.rawQuery)({url:this.endpoint,query:`{${this.#s}{metaDataType{query(first:100,filter:"{type:'reference',attributes:{isDefault:true}}"){edges{node{attributes}}}}}}`,headers:this.getAuthorizationHeader(),locale:this.options.userLocale});return t.data[this.#s]?.metaDataType?.query.edges.forEach(e=>{const t=JSON.parse(e.node.attributes);if("string"==typeof t.node&&t.lookup?.tunnelPage){const e=t.node.split("/").pop();if(e)this.#n[e]=t.lookup.tunnelPage}}),this.#n[e]}static create(e){return new MetadataManager(e)}}exports.MetadataManager=MetadataManager;
//# sourceMappingURL=metadata-manager.js.map