import type { ChatbotListExportParams } from '@sage/xtrem-core';
import { DataExportOptions } from './mcp-server.js';
import { ToolResponse } from './utils.js';
export type UnPromised<T> = T extends Promise<infer U> ? U : T;
export type DataTypeMeta = UnPromised<ReturnType<MetadataManager['fetchDataTypesPage']>>['data'][number];
export type NodeMeta = UnPromised<ReturnType<MetadataManager['fetchNodesMetadataPage']>>['data'][number];
export type NodeMetaWithPageName = NodeMeta & {
    pageName: string | null;
};
export type PropertyMeta = NodeMeta['properties'][number];
export type OperationMeta = NodeMeta['operations'][number];
export type ParameterMeta = {
    name: string;
    type: string;
    isMandatory?: boolean;
    items?: ParameterMeta[];
    properties?: ParameterMeta[];
    dataType?: string;
};
export interface MetadataManagerCreateOptions {
    applicationName: string;
    endpoint: string;
    bearerToken: string;
    userLocale: string;
    apiRoute: 'api' | 'proxy';
    exportListOptions?: DataExportOptions;
    isProxy?: boolean;
}
/**
 * Metadata manager
 *
 * This is created with MetadataManager.create(options), which caches the metadata manager instance.
 *
 * There is one metadata manager instance per endpoint, as all the tenants and their users share the same metadata
 * (the metadata tables are shared by all tenants and all users have access to it).
 *
 * Note: we need a separate manager for custom fields, because those are specific to each tenant.
 */
export declare class MetadataManager {
    #private;
    private options;
    private constructor();
    private get endpoint();
    private getAuthorizationHeader;
    private fetchAllPages;
    private fetchDataTypesPage;
    private nodesFilter;
    private fetchAllNodeNamesPage;
    private fetchNodesMetadataPage;
    private fetchAllNodeNames;
    private fetchDataTypes;
    private fetchNodesMetadata;
    private fetchMissingMetadata;
    private collectParamDataTypeNames;
    private collectNodeDataTypeNames;
    private collectNodesDataTypeNames;
    getAllNodeNames(): Promise<string[]>;
    private loadMissingMetadata;
    private getMetadataSections;
    getMetadataText(nodeNames: string[]): Promise<ToolResponse>;
    private getOperationMetadataText;
    getOperationMetadata(nodeName: string, operationName: string): Promise<ToolResponse>;
    createExportedList(exportParams: ChatbotListExportParams): Promise<ToolResponse>;
    getTunnelPageName(nodeName: string): Promise<string | null>;
    static create(options: MetadataManagerCreateOptions): MetadataManager;
}
//# sourceMappingURL=metadata-manager.d.ts.map