/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MetadataFormatter=void 0;const _=require("lodash");class MetadataFormatter{static formatEnums(e){return`\n# Enums\n\n| Enum               | Values             |\n| ------------------ | ------------------ |\n${e.join("\n")}\n\n`}static parseDataTypeAttributes(e){const t=JSON.parse(e||"{}");return{enumName:t.enumName,enumValues:Object.values(t.enum||{}).filter(e=>!/^\d/.test(String(e)))}}static formatEnum(e){const{enumName:t,enumValues:a}=this.parseDataTypeAttributes(e.attributes);return`| ${t} | ${a} |`}static getPropertyEnumName(e){return"enum"===e.type?this.parseDataTypeAttributes(e.dataType?.attributes??"{}").enumName:""}static formatProperty(e){return`| ${e.name} | ${e.type} | ${e.isNullable} | ${!e.hasDefaultValue} | ${this.getPropertyEnumName(e)} | ${e.targetFactory?.name??""} | ${e.isOnInputType} | ${e.isOnOutputType} | ${e.isVital} | ${e.canFilter} | ${e.canSort} |`}static getOperationNames(e,t){return e.filter(e=>t.includes(e.kind)).map(e=>e.name)}static invalidNodeName(e){return`\n# ${e}: INVALID NODE NAME\n\nOnly use node names returned by the getApiDocumentation tool!\n`}static formatNode(e){const t=["create","update","delete",...this.getOperationNames(e.operations,["mutation"])],a=this.getOperationNames(e.operations,["asyncMutation"]),n=this.getOperationNames(e.operations,["query"]);return`\n# ${e.name} (package: ${_.camelCase(e.package.name.split("/")[1]||e.package.name)})\n\n## Properties\n\n| Property Name | Type | Nullable | Required | Enum | Target Node | Is input | Is output | Is component | can filter | can sort |\n| -- | -- | -- | -- | -- | -- | -- | -- | -- |\n${e.properties.map(e=>this.formatProperty(e)).join("\n")}\n\n## Operations\n\n- Mutation names: ${t.join(",")||"<none>"},\n- Async mutation names: ${a.join(",")||"<none>"},\n- Custom query names: ${n.join(",")||"<none>"}\n\n## Natural Key\n\n${e.naturalKey?`Natural key: ${e.naturalKey.join(",")}`:"No natural key defined."}\n\n## Page Name\n\n${e.pageName?`Page name: ${e.pageName}`:"No page name defined (no direct links available)."}\n`}static formatOperation(e){return JSON.stringify(e,null,2)}}exports.MetadataFormatter=MetadataFormatter;
//# sourceMappingURL=metadata-formatter.js.map