/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.McpServerHelper=void 0;const mcp_js_1=require("@modelcontextprotocol/sdk/server/mcp.js"),json5=require("json5"),_=require("lodash"),fs=require("node:fs"),path=require("node:path"),zod_1=require("zod"),documentation_service_js_1=require("./documentation-service.js"),fetch_js_1=require("./fetch.js"),metadata_manager_js_1=require("./metadata-manager.js"),prompts_js_1=require("./prompts.js"),utils_js_1=require("./utils.js"),logger=(0,utils_js_1.getLogger)(__filename,"server");class McpServerHelper{constructor(e){this.options=e,logger.info(`Creating MCP server for application: ${e.applicationName}, endpoint: ${e.endpoint}`);const t=(0,utils_js_1.getPackageVersion)();if(this.server=new mcp_js_1.McpServer({name:`sage-xtrem-${_.kebabCase(e.applicationName)}-mcp-server`,description:prompts_js_1.Prompts.serverDescription(e.applicationName,e.nodeNames),version:t,options:{cache_control:{type:"ephemeral"}}}),this.addGetApiDocumentationTool(),this.addGetMetadataTool(),this.addGetOperationMetadataTool(),this.addQueryTool(),this.addGetDocumentationTopics(),this.addGetDocumentationPageContent(),this.addChartTool(),this.addInternalLinkGenerationTool(),this.options.exportListOptions)this.addCreateExportTool();this.addGetWorkflowDocumentationTool(),logger.info("MCP Server created")}get metadataManager(){return this.options.metadataManager}async executeGraphqlQuery(e){logger.debug(()=>`[TOOL] queryGraphql called: query=${e}`);const t=await(0,fetch_js_1.executeQuery)({url:this.options.endpoint,headers:{Authorization:`Bearer ${this.options.bearerToken}`,"Content-Type":"application/json"},locale:this.options.userLocale,query:e,endpoint:this.options.apiRoute});return logger.debug(()=>`[TOOL] queryGraphql returns: ${JSON.stringify(t,utils_js_1.ellipsesText,2)}`),t}waitForSeconds(e){return new Promise(t=>setTimeout(t,1e3*e))}addQueryTool(){this.server.tool("queryGraphql",prompts_js_1.Prompts.queryGraphqlDescription(),{query:zod_1.z.string().describe("The GraphQL query to execute"),waitInSeconds:zod_1.z.number().optional().describe("An optional wait time in seconds before executing the query")},async({query:e,waitInSeconds:t})=>{if(t)await this.waitForSeconds(t);return this.executeGraphqlQuery(e)})}addGetMetadataTool(){this.server.tool("getMetadata",prompts_js_1.Prompts.getMetadataDescription(),{nodeNames:zod_1.z.array(zod_1.z.string()).describe("Node names to retrieve metadata for")},{cache_control:{type:"ephemeral"}},async({nodeNames:e})=>{logger.debug(()=>`[TOOL] getMetadata called: nodeNames=${e.join(", ")}`);const t=await this.metadataManager.getMetadataText(e.map(utils_js_1.capitalize));return logger.debug(()=>`[TOOL] getMetadata returns: ${JSON.stringify(t,null,2)}`),t})}addGetOperationMetadataTool(){this.server.tool("getOperationMetadata",prompts_js_1.Prompts.getOperationMetadataToolDescription(),{nodeName:zod_1.z.string().describe("Node name to retrieve operation metadata for"),operationName:zod_1.z.string().describe("Operation name to retrieve metadata for")},{cache_control:{type:"ephemeral"}},async({nodeName:e,operationName:t})=>{logger.debug(()=>`[TOOL] getOperationMetadata called: nodeName=${e}, operationName=${t}`);const o=await this.metadataManager.getOperationMetadata((0,utils_js_1.capitalize)(e),t);return logger.debug(()=>`[TOOL] getOperationMetadata returns: ${JSON.stringify(o,utils_js_1.ellipsesText,2)}`),o})}addCreateExportTool(){const e=this.options.exportListOptions?.supportedExportListTypes||[];if(_.isEmpty(e))throw new Error("Cannot register export tool: No supported export formats available");this.server.tool("createListExport",prompts_js_1.Prompts.addCreateExportTool(),{nodeName:zod_1.z.string().describe("Node name to export data from"),outputFormat:zod_1.z.enum(e).describe("The format to export the data to"),templateDefinition:zod_1.z.array(zod_1.z.object({path:zod_1.z.string().describe("The dot-notated path of the property to include in the export"),title:zod_1.z.string().describe("The column title to use in the export")})).describe("List of properties to be exported"),filter:zod_1.z.string().optional().describe("JSON5-stringified GraphQL filter statement"),orderBy:zod_1.z.string().optional().describe("JSON5-stringified GraphQL orderBy statement")},{cache_control:{type:"ephemeral"}},async e=>{logger.debug(()=>`[TOOL] createListExport called: nodeName=${e.nodeName}, outputFormat=${e.outputFormat}`);const t=await this.metadataManager.createExportedList(e);return logger.debug(()=>`[TOOL] createListExport returns: ${JSON.stringify(t,utils_js_1.ellipsesText,2)}`),t})}addChartTool(){this.server.tool("createChart",prompts_js_1.Prompts.addChartTool(),{chartType:zod_1.z.enum(["bar","line","pie"]).describe("The type of chart to generate"),baseAxis:zod_1.z.string().describe('The property name to use for the base axis (e.g., "date", "category")'),data:zod_1.z.array(zod_1.z.record(zod_1.z.union([zod_1.z.string(),zod_1.z.number()]))).describe("An array of objects, each with a key for the baseAxis value and other values for the data points. The data points must have the same keys across all objects.")},async e=>{logger.debug(()=>`[TOOL] createChart called: type=${e.chartType}`);const t=(0,utils_js_1.toolSuccess)([`\`\`\`chart-json\n${JSON.stringify(e,null,2)}\n\`\`\``]);return logger.debug(()=>`[TOOL] createChart returns: ${JSON.stringify(t,utils_js_1.ellipsesText,2)}`),t})}getDocumentation(e){const t=path.join((0,utils_js_1.getPackageDir)(),"resources",e);return fs.promises.readFile(t,"utf-8")}addGetApiDocumentationTool(){this.server.tool("getApiDocumentation",prompts_js_1.Prompts.getApiDocumentationDescription(),{},async()=>{logger.debug(()=>"[TOOL] getApiDocumentation called");const e=await this.getDocumentation("xtrem-graphql-doc.md"),t=this.options.nodeNames.sort().join(", "),o=e+`\n\n# Available Node Names\n\nThe API exposes the following ${this.options.nodeNames.length} business data nodes:\n\n${t}\n\n**IMPORTANT**: Only use node names from the list above - never guess or assume node names exist.`;return logger.debug(()=>`[TOOL] getApiDocumentation returns: ${(0,utils_js_1.ellipsesText)(o)}`),{isError:false,content:[{type:"text",text:o}]}})}addGetWorkflowDocumentationTool(){this.server.tool("getWorkflowDocumentation",prompts_js_1.Prompts.getWorkflowDocumentationDescription(),{},async()=>{logger.debug(()=>"[TOOL] getWorkflowDocumentation called");const e=await this.getDocumentation("xtrem-workflow-doc.md");return logger.debug(()=>`[TOOL] getWorkflowDocumentation returns: ${(0,utils_js_1.ellipsesText)(e)}`),{isError:false,content:[{type:"text",text:e}]}})}addGetDocumentationTopics(){this.server.tool("getDocumentationTopics",prompts_js_1.Prompts.getDocumentationTopicsDescription(),{},{cache_control:{type:"ephemeral"}},async()=>{if(!this.options.documentationServiceUrl)return logger.debug(()=>"[TOOL] getDocumentationTopics: No documentation URL configured"),{isError:true,content:[{type:"text",text:"No documentation available"}]};const e=await(0,documentation_service_js_1.getDocumentationTopics)(this.options.documentationServiceUrl);return{isError:false,content:[{type:"text",text:Object.keys(e).join(", ")}]}})}addGetDocumentationPageContent(){this.server.tool("getDocumentationPageContent",prompts_js_1.Prompts.getDocumentationPageContentDescription(),{topic:zod_1.z.string().describe("The name of the documentation topic to retrieve content for")},async({topic:e})=>{if(!this.options.documentationServiceUrl)return logger.debug(()=>"[TOOL] getDocumentationPageContent: No documentation URL configured"),{isError:true,content:[{type:"text",text:"No documentation available"}]};if(!e)return logger.debug(()=>"[TOOL] getDocumentationPageContent: No topic specified"),{isError:true,content:[{type:"text",text:"No documentation available"}]};const t=await(0,documentation_service_js_1.getDocumentationPageContent)(this.options.documentationServiceUrl,e);if(!t)return logger.debug(()=>`[TOOL] getDocumentationPageContent: No content found for topic ${e}`),{isError:true,content:[{type:"text",text:"No documentation available"}]};return{isError:false,content:[{type:"text",text:t}]}})}addInternalLinkGenerationTool(){this.server.tool("getInternalLink",prompts_js_1.Prompts.getInternalLinkDescription(),{nodeName:zod_1.z.string().describe("The name of the node to generate an internal link for"),filter:zod_1.z.string().optional().describe("JSON5-stringified GraphQL filter statement")},async({nodeName:e,filter:t})=>{if(!e)return logger.debug(()=>"[TOOL] getInternalLink: No nodeName specified"),{isError:true,content:[{type:"text",text:"No node name specified"}]};const o=await this.metadataManager.getTunnelPageName(e);if(!o)return logger.debug(()=>`[TOOL] getInternalLink: No tunnel page found for node ${e}`),{isError:true,content:[{type:"text",text:`No internal link available for node ${e}`}]};const r=t?json5.parse(t):void 0;if(r._id)return{isError:false,content:[{type:"text",text:`${o}/${r._id}`}]};return{isError:false,content:[{type:"text",text:`${o}/${Buffer.from(JSON.stringify({_filter:JSON.stringify(r)})).toString("base64")}`}]}})}static async create(e){const t=e.isProxy?"proxy":"api",o=metadata_manager_js_1.MetadataManager.create({...e,apiRoute:t}),r=await o.getAllNodeNames();return(await new McpServerHelper({...e,metadataManager:o,nodeNames:r,apiRoute:t})).server}}exports.McpServerHelper=McpServerHelper;
//# sourceMappingURL=mcp-server.js.map