import { McpServer } from '@modelcontextprotocol/sdk/server/mcp.js';
import type { ChatbotListExportParams, ChatbotListExportTargetExtension } from '@sage/xtrem-core';
import { MetadataManager } from './metadata-manager.js';
import { ToolResponse } from './utils.js';
export interface DataExportOptions {
    supportedExportListTypes: ChatbotListExportTargetExtension[];
    exportList: (exportParams: ChatbotListExportParams, executeApiQuery: <T = unknown>(query: string) => Promise<T>) => Promise<string>;
}
export interface CreateOptions {
    endpoint: string;
    applicationName: string;
    tenantId: string;
    userEmail: string;
    userLocale: string;
    bearerToken: string;
    documentationServiceUrl?: string;
    exportListOptions?: DataExportOptions;
    isProxy?: boolean;
}
export interface ConstructOptions extends CreateOptions {
    metadataManager: MetadataManager;
    apiRoute: 'api' | 'proxy';
    nodeNames: string[];
}
export interface Tool {
    name: string;
    description: string;
    parameters: Record<string, any>;
    execute: (args: Record<string, any>) => Promise<ToolResponse>;
}
export declare class McpServerHelper {
    readonly options: ConstructOptions;
    readonly server: McpServer;
    constructor(options: ConstructOptions);
    get metadataManager(): MetadataManager;
    private executeGraphqlQuery;
    private waitForSeconds;
    private addQueryTool;
    private addGetMetadataTool;
    private addGetOperationMetadataTool;
    private addCreateExportTool;
    private addChartTool;
    private getDocumentation;
    private addGetApiDocumentationTool;
    private addGetWorkflowDocumentationTool;
    private addGetDocumentationTopics;
    private addGetDocumentationPageContent;
    private addInternalLinkGenerationTool;
    static create(createOptions: CreateOptions): Promise<McpServer>;
}
//# sourceMappingURL=mcp-server.d.ts.map