/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.rawQuery=rawQuery,exports.executeQuery=executeQuery;const xtrem_core_1=require("@sage/xtrem-core"),_=require("lodash"),node_fetch_1=require("node-fetch"),utils_js_1=require("./utils.js"),logger=(0,utils_js_1.getLogger)(__filename,"metadata-manager");async function rawQuery({url:e,locale:r,headers:t,query:s,endpoint:o="api"}){const n=`${_.trimEnd(e,"/")}/${o}`,u=xtrem_core_1.TlsHelper.getInteropHttpsAgent();logger.debug(()=>`[TOOL] rawQuery called: url=${n}, query=${s}`);const a={method:"POST",headers:{"Content-Type":"application/json","Accept-Language":r,...t},body:JSON.stringify({query:s})};if(u)a.agent=u;const i=await(0,node_fetch_1.default)(n,a);if(!i.ok){const e=await i.text();throw new Error(`GraphQL request failed: ${i.statusText}\n${e}`)}const c=await i.json();if(c.errors&&c.errors.length>0)throw new Error(`The GraphQL response has errors, please fix the query: ${JSON.stringify(c,null,2)}`);return c}async function executeQuery(e){try{const r=await rawQuery(e);return(0,utils_js_1.toolSuccess)([JSON.stringify(r,null,2)])}catch(e){return(0,utils_js_1.toolError)(e)}}
//# sourceMappingURL=fetch.js.map